/*
 * Copyright (C) 1995,1996 Lars Fenneberg, Joao Ventura
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <syslog.h>
#include <errno.h>
#include "ipstats.h"

char *pname = NULL;
int use_syslog = 0;

void log(char *format, ...)
{
        char buff[1024];
        va_list ap;
                    
        va_start(ap,format);
        vsprintf(buff, format, ap);
        va_end(ap);

	if (use_syslog)
		syslog(LOG_ERR, buff);
	else
		fprintf(stderr,"%s: %s.\n", pname, buff);
}

char *my_perror(char *what)
{
	static char message[255];
        if (what == NULL || *what == '\0')
        	sprintf(message,"%s", strerror(errno));
	else
        	sprintf(message,"%s: %s", what, strerror(errno));
        return message;
}
