/*
 * Copyright (C) 1995,1996 Joao Ventura, Lars Fenneberg
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <sys/types.h>

#define HASH_TABLE_SIZE		111
#define HASH_FUNC(uid)		((uid) % HASH_TABLE_SIZE)

#define MAX_TRIES		20 /* maximum tries to look database */

struct user_hash_s {

	uid_t uid;
	signed long stats;
	int flags;

	struct user_hash_s *next;	
};

/* main */
extern int skfd;

/* log.c */
extern char *pname;
extern int use_syslog;
extern void log(char *, ...);
extern char *my_perror(char *);

/* hash.c */
extern struct user_hash_s *hash_table[];
extern void init_hash(void);
extern struct user_hash_s *exist_user(uid_t);
extern struct user_hash_s *add_user(uid_t, signed long, int);
extern void change_user(uid_t, signed long, int);
extern void change_all(signed long, int);
extern void ctrl_access(uid_t, int);
extern void ctrl_access_all(void);

/* database.c */
extern void init_database(char *);
extern void close_database(char *);

/* version.c */
extern void version(void);
