/*
 * Copyright (C) 1995,1996 Lars Fenneberg, Joao Ventura
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
 
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <pwd.h>
#include <signal.h>
#include <getopt.h>
#include <ctype.h>
#include <sys/socket.h>
#include <linux/ip_acct_user.h>
#include "ipstats.h"
#include "pathnames.h"

#define ALLOW (~IPAU_NO_ACCESS)
#define DENY IPAU_NO_ACCESS

int skfd = -1;

void usage(void)
{
	fprintf(stderr,"Usage: %s [-vdah] <username/uid>\n", pname);
	exit(1);
}

void catch_sig(int sig)
{
	close_database(_PATH_VAR_LOG_IP_STATS);
	log("terminating (signal %i)", sig);
	exit(1);
}

void main (int argc,char **argv) {

	int allow=ALLOW;
	struct passwd *pwd;
  	extern int optind; 
  	extern char *optarg;
  	struct user_hash_s *p;
  	int c;

	use_syslog = 0;
 	pname = argv[0];

	signal(SIGINT, catch_sig);
	signal(SIGTERM, catch_sig);
	signal(SIGQUIT, catch_sig);
	signal(SIGHUP, catch_sig);

  	while ((c = getopt(argc,argv,"vdah")) > 0) 
  	{
  		switch (c)
  		{
			case 'v':
					version();
					break;
			case 'd':
					allow=DENY;
					break;
			case 'a':
					allow=ALLOW;
					break;
  			case 'h':
  			default:
  					usage();
  					break; /* never reached */
  		}
  	}
	
	if ((argc-optind)==1) {
		if ( ((pwd = getpwnam(argv[optind])) == NULL) 
			&& ((pwd = getpwuid(atoi(argv[optind]))) == NULL)) 
		{
			log("no such user/uid: %s", argv[optind]);
			exit(1);
		}

        	if ((skfd = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
                {
                	log(my_perror("can't create socket"));
                        exit (1);
                }

		init_hash();
		init_database(_PATH_VAR_LOG_IP_STATS);
		
		ctrl_access_all();

		if ((p=exist_user(pwd->pw_uid))) {
			if (allow==DENY) p->flags |= DENY;
			else p->flags &= ALLOW;
			ctrl_access(p->uid,p->flags);
		}
		else
			(void)add_user(pwd->pw_uid, 0,(IPAU_NO_ACCESS & allow));

		ctrl_access_all();
		close_database(_PATH_VAR_LOG_IP_STATS);
		close(skfd);
	} else {
		usage();
	}
}
