/*---------------------------------------------------------------------------

	Program:	SETHOST
	Function:	Terminal emulation using CTERM over DECnet
	Author:		Eduardo Marcelo Serrat

-----------------------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <sched.h>
#include <signal.h>
#include <ctype.h>
#include <linux/dn.h>
#include <linux/termios.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/fcntl.h>
#include "dnlib.h"
#include "cterm.h"

#define	TRUE	1
#define FALSE	0

struct	sockaddr_dn		sockaddr;
struct	accessdata_dn		accessdata;
static  struct	dn_naddr	*binadr;
struct	termio			raw,cooked;
struct	logical_terminal_characteristics
				log_char = {FALSE,3,5,'V','T','2','0','0'
					    ,TRUE,
					    TRUE,TRUE,TRUE,TRUE,80,24,0,0,
					    0,1,1,1,1};

struct	physical_terminal_characteristics
				phy_char = {9600,9600,8,FALSE,1,FALSE,FALSE,
					    FALSE,0,0,FALSE,FALSE};
struct	handler_maintained_characteristics
				han_char = {FALSE,FALSE,FALSE,TRUE,TRUE,TRUE,
					    1,FALSE,FALSE};
unsigned char			char_attr[256];

char				nodename[20],inpbuf[132],buf[1000],
				ahead[32];
short				bufptr,blklen,cnt;
static int			sockfd, ttyfd;
static int			rptr=0,wptr=0,
				aheadcnt=0,inpcnt=0,inpptr=0;
static short			wrpflg=FALSE, read_present=FALSE,lockflg=FALSE,
				discard=FALSE,unbind=FALSE,hold=FALSE,
				redisplay=FALSE,output_lost=FALSE,
				uu,c,f,v,k,ii,ddd,n,t,q,zz,ee,
				max_len,end_of_data,timeout,end_of_prompt,
				start_of_display,low_water,escseq=FALSE,
				esclen=0;
unsigned char			term_tab[32];
/*-------------------------------------------------------------------------*/
static void ct_reset_term(void)
{
	if ( ioctl(ttyfd,TCSETA,&cooked) < 0)
	{
		perror("ioctl TCSETA");
		exit(-1);
	}
	close(ttyfd);
}
/*-------------------------------------------------------------------------*/
short	escseq_terminator(char car)
{
	char	escend [23] = {'A','B','C','D','M','P','Q','R','S',
			     'l','m','n','p','q','r','s','t','u','v',
			     'w','x','y','~'};
	int	i;

	for (i=0; i < 23; i++) if (car==escend[i]) return 1;
	return 0;
}
/*-------------------------------------------------------------------------*/
static void ct_terminate_read(char flgs)
{
	char	readbuf[132];
	char	t;
	short	*p;
	int	readptr,i;

	read_present = FALSE;
	alarm(0);

	readbuf[0] = 0x09;
	readbuf[1] = 0x00;
	readbuf[4] = 0x03;
	if (aheadcnt > 0) t = 0x10;
	else		  t = 0x00;
	readbuf[5] = flgs | t;
	readbuf[6] = readbuf[7] = 0x00;
	readbuf[8] = 0x00;
	readbuf[9] = 0x00;
	p=(void *)&readbuf[10];
	if (inpcnt > 0) *p=inpcnt - 1;
	else            *p = 0;
	if (escseq)
	{
		*p = inpcnt - esclen;
		esclen=escseq=0;
	}

	for (i=0; i < inpcnt; i++)
	{
		readbuf[i+12] = inpbuf[end_of_prompt + i];
	}
	p=(void *)&readbuf[2];
	*p=inpcnt + 8;

	if (write(sockfd,readbuf,inpcnt+12) < 0)
	{
		perror("Terminate Read message");
		ct_reset_term();
		exit(-1);
	}
	inpcnt=inpptr=0;
}
/*-------------------------------------------------------------------------*/
static	short	ct_is_terminator(char car)
{
	short	termind,msk,aux;

	termind=car / 8;
	aux = car - (termind * 8);
	msk= (1 << aux);

	if (term_tab[termind] && msk) return 1;
	return 0;
}

/*-------------------------------------------------------------------------*/
static void ct_timeout_proc(int x)
{
	ct_terminate_read(5);
	signal(SIGALRM,ct_timeout_proc);
}
/*-------------------------------------------------------------------------*/
static void ct_echo_input_char(char *c)
{
	char	car;
	if ((n) || ((t==0) && ct_is_terminator(*c))) return;
	while (lockflg||hold) ;
	if (ii==2)
	{
		car=toupper(*c);
		write(ttyfd,&car,1);
		*c=car;
	}
	else
		write(ttyfd,c,1);
}
/*-------------------------------------------------------------------------*/
static void ct_input_proc (char car)
{
	char	clrchar[3] = {0x08,0x20,0x08};

	if ((car == DEL) && ( (zz == 2) || (!ct_is_terminator(car))))
	{
		if (inpcnt > 0)
		{
			inpcnt -= 1;
			inpptr -= 1;
			if (n==0)
				write(ttyfd,&clrchar,3);
		}
		return;
	}
/*
	if ((zz == 2 ) && (car == ESC) && (han_char.input_escseq_recognition)) 
*/
	if (car == ESC)
		escseq=TRUE;
	if (!escseq) 
		ct_echo_input_char(&car);
	
	inpbuf[inpptr++]=car;
	inpcnt += 1;
	if (inpcnt == max_len) ct_terminate_read(4);
	if (escseq)
	{
		esclen += 1;
		if (escseq_terminator(car)) ct_terminate_read(1);
		return;
	}
	if (zz==2) 
	{
		if  (car < 0x1B)
		ct_terminate_read(0);
	}
	else
	{
		if (ct_is_terminator(car)) ct_terminate_read(0);
	}
}
/*-------------------------------------------------------------------------*/
static int	ct_out_of_band (char car)
{
	char	msg[7] = {0x09,0x00,0x03,0x00,0x04,0x00,0x00};
	char	oo,d,i,ee,f;
	
	oo=char_attr[car] & 0x03;
	i =(char_attr[car] & 0x04) >> 2;
	d =(char_attr[car] & 0x08) >> 3;
	ee=(char_attr[car] & 0x30) >> 4;
	f =(char_attr[car] & 0x40) >> 6;
	
	if (oo==0) return 0;
	msg[5]=d;
	msg[6]=car;
	if (write(sockfd,msg,7) < 0)
	{
		perror("Out of band Msg");
		ct_reset_term();
		exit(-1);
	}
	if (d) discard=TRUE;
	if (ee)
	{
		if ( (car==CTRL_C) || (car==CTRL_Y) )
			write(ttyfd,"\n*Interrupt*\n",13);
	}
	if (oo==1)
		aheadcnt=rptr=wptr=wrpflg=0;
	if (oo==3)
		redisplay=TRUE;
	if ((oo==3) && (i==1)) return 0; 
	
	return 1;
	
}
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
static void	ct_setup(void)
{
	int	i;

	for (i=0; i < 32; i++) term_tab[i]=0;
	for (i=0; i < 256; i++) char_attr[i]=0;
	

	if (getnodebyname(nodename) == NULL)
	{
	   printf("No entry in /etc/decnet.conf for %s\n",nodename);
	   exit();
	}
	binadr = dnet_addr(getnodebyname(nodename));
	if (binadr == NULL) {
		   printf("Server %s address invalid.\n",nodename);
		   exit();
	}
}
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
static unsigned char	read_ahead(void)
{
	char	c;
	
	if ((rptr+wrpflg) == wptr) return -1;
	c=ahead[rptr];
	aheadcnt -= 1;
	rptr=(rptr+1) & 31;
	if (rptr == 0) wrpflg=0;
	return c;
}
/*------------------------------------------------------------------------*/

static int	insert_ahead(char c)
{
	int	er;
	char	buf[6] = {0x09,0x00,0x02,0x00,0x0E,0x01};


	if (( rptr == wptr) && (wrpflg) ) return -1;
	ahead[wptr] = c;
	wptr=(wptr+1) & 31;
	if ( wptr == rptr ) wrpflg = 1;
	aheadcnt += 1;
	if ( (aheadcnt == 1) && (han_char.input_count_state > 1) )
	{
		if (!read_present) 
		{
			if ( (er=write(sockfd,buf,6)) < 0 )
			{
				perror("Error sending count state msg");
				ct_reset_term();
				exit(-1);
			}
		}
	}
	return 0;
}
/*-------------------------------------------------------------------------*/
static void	ct_setup_link(void)
{
	short		*p;
	unsigned char	initsq[31]={0x09,0x00,27,0x00,0x01,0x00,0x01,0x04,0x00,
				    'L','n','x','C','T','E','R','M',
				    0x01,0x02,0x00,0x02,     /* Max msg size*/
				    0x02,0x02,0xF4,0x03,     /* Max input buf*/
				    0x03,0x04,0xFE,0x7F,0x00,/* Supp. Msgs   */
				    0x00
				   };
	printf("sethost V0.0.1\n");
	printf("Connecting to %s\n",nodename);
  	if ((sockfd=socket(AF_DECnet,SOCK_SEQPACKET,DNPROTO_NSP)) == -1) 
	{
    		perror("socket");
    		exit(-1);
  	}


	sockaddr.sdn_family = AF_DECnet;
	sockaddr.sdn_flags	= 0x00;
	sockaddr.sdn_objnum	= 0x2A;			/* CTERM*/
	sockaddr.sdn_objnamel	= 0x00;
	memcpy(sockaddr.sdn_add.a_addr, binadr->a_addr,6);

	if (connect(sockfd, (struct sockaddr *)&sockaddr, 
		sizeof(sockaddr)) < 0) 
	{
		perror("socket");
		exit(-1);
	}

	if ( (cnt=read(sockfd,buf,sizeof(buf))) < 0)
	{
		printf("ct_setup_link: error receiving bind from host\n");
		exit(-1);
	}
	if (buf[0] != 0x01)
	{
		printf("ct_setup_link: Not bind from host\n");
		exit(-1);
	}
	buf[0]=0x04;				/* bind accept flag	*/	
	
	if ( (cnt=write(sockfd,buf,6)) < 0)
	{
		printf("ct_setup_link: error sending bind accept\n");
		exit(-1);
	}

	if ( (cnt=write(sockfd,initsq,sizeof(initsq))) < 0)
	{
		printf("ct_setup_link: error sending init sequence\n");
		exit(-1);
	}

	if ( (cnt=read(sockfd,buf,sizeof(buf))) < 0)
	{
		printf("ct_setup_link: error receiving initiate/host\n");
		exit(-1);
	}
	p=(void *)&buf[2];
	blklen=*p;	
	bufptr=blklen+4;
	printf("Connected. Escape Sequence  is ^]\n\n\n");
}

/*-------------------------------------------------------------------------*/
static void	ct_init_term(void)
{
	long	savflgs;

	ttyfd=open("/dev/tty",O_RDWR);

	if ( ioctl(ttyfd,TCGETA,&cooked) < 0)
	{
		perror("ioctl TCGETAR");
		exit(-1);
	}
	memcpy(&raw,&cooked,sizeof(struct termio));

	raw.c_iflag &= INLCR;
	raw.c_lflag &= ~(ICANON | ISIG | ECHO);
	raw.c_cc[4] = 1;
	raw.c_cc[5] = 2;
	
	if ( ioctl(ttyfd,TCSETA,&raw) < 0)
	{
		perror("ioctl TCSETA");
		exit(-1);
	}
	if ( (savflgs=fcntl(ttyfd,F_GETFL)) < 0)
	{
		perror("getflg");
		ct_reset_term();
		exit(-1);
	}
	if ( (fcntl(ttyfd,F_SETFL,savflgs|FASYNC)) < 0)
	{
		perror("setflg");
		ct_reset_term();
		exit(-1);
	}
}
/*-------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------*/
static void ct_preinput_proc(int x)
{
	char	c;
	char	buf[80];
	int	i,cntx;

	cntx=read(ttyfd,&buf,80);
	for (i=0; i < cntx; i++)
	{	
		c=buf[i];
		if (c==0x1D)			
		{
			ct_reset_term();
			printf("\n\nControl returned to local host.\n");
			exit();
		}
		if (c==BS) c=DEL;
		switch(c)
		{
			case CTRL_X:	wptr = rptr = wrpflg = 0;
					break;
			case CTRL_O:	discard = ~discard;
					if (discard) 
					   write(ttyfd,"\n*output off*\n",14);
					else
					   write(ttyfd,"\n*output on*\n",13);
					break;
			case CTRL_S:	hold=TRUE;
					break;
			case CTRL_Q:	hold=FALSE;
					break;
			default:
					if (ct_out_of_band(c)) break;
					if (read_present) 
					{
						ct_input_proc(c);
						if (q) alarm(timeout);
					}
					else
					      if (insert_ahead(c) < 0)
					       	  write(ttyfd,&BELL,1);
		}
	}
	signal(SIGIO,ct_preinput_proc);	/* re-establish itself     */
} 
/*-------------------------------------------------------------------------*/
static void ct_print_char(char *c)
{
	if (discard)
	{
		output_lost=TRUE;
		return;
	}
	while (hold) ;
	write(ttyfd,c,1);
}
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/


static void ct_echo_prompt(char *c)
{
	while (lockflg||hold) ;
	write(ttyfd,c,1);
}
/*-------------------------------------------------------------------------*/
static void ct_read_req(void)
{
	unsigned char	flg;
	char		car;
	short	*p,i,termlen,procnt;

	bufptr += 1;				/* Point to first flag char*/
	flg=buf[bufptr];

	uu = flg & 0x03;
	c  = (flg & 0x04) >> 2;
	f  = (flg & 0x08) >> 3;
	v  = (flg & 0x10) >> 4;
	k  = (flg & 0x20) >> 5;
 	ii = (flg & 0xC0) >> 6;

	bufptr  += 1;
	flg=buf[bufptr];

	ddd = (flg & 0x07);
	n   = (flg & 0x08) >> 3;
	t   = (flg & 0x10) >> 4;
	q   = (flg & 0x20) >> 5;
	zz  = (flg & 0xC0) >> 6;

	bufptr  += 1;
	flg=buf[bufptr];
	
	ee  = (flg & 0x03);
	bufptr += 1;					/* Point to next char */

	p=(void *)&buf[bufptr];
	max_len=*p;
	bufptr += 2;	

	p=(void *)&buf[bufptr];
	end_of_data=*p;
	bufptr += 2;	

	p=(void *)&buf[bufptr];
	timeout=*p;
	bufptr += 2;	

	p=(void *)&buf[bufptr];
	end_of_prompt=*p;
	bufptr += 2;	

	p=(void *)&buf[bufptr];
	start_of_display=*p;
	bufptr += 2;	

	p=(void *)&buf[bufptr];
	low_water=*p;
	bufptr += 2;	
	termlen = buf[bufptr];
	bufptr += 1;
	procnt=17;
	for (i=0; i < termlen; i++) 
	{
		term_tab[i]=buf[bufptr];
		bufptr += 1;
		procnt += 1;
	}
	if (c) aheadcnt=rptr=wptr=wrpflg=inpcnt=inpptr=0;
	while (procnt < blklen)
	{
		inpbuf[inpptr++]=buf[bufptr];
		ct_echo_prompt(&buf[bufptr]);
		if (inpptr > end_of_prompt) inpcnt += 1;
		bufptr += 1;
		procnt += 1;
	}
	read_present = TRUE;
	while ((read_present) && (aheadcnt > 0))
	{
		car=read_ahead();
		ct_input_proc(car);
	}
	if (read_present)
		if ((q==1) && (timeout==0) ) ct_terminate_read(5);
	if ((read_present) && (q==1)) alarm(timeout);
}
/*-------------------------------------------------------------------------*/
static void ct_unread_req(void)
{
	bufptr += 1;				/* Point to unread flag	*/

	if (buf[bufptr] == 0) ct_terminate_read(6);
	else
		if ((aheadcnt+inpcnt)==0) ct_terminate_read(6);
	bufptr += 1;
}
/*-------------------------------------------------------------------------*/
static void ct_clearinput_req(void)
{
	bufptr += 2;
	rptr=wptr=wrpflg=inpcnt=0;
}
/*--------------------------------------------------------------------------*/
static void ct_write_req(void)
{
	short	*p;
	short	procnt, flgs,i;
	short	uu,l,d,b,e,pp,qq,s,t;
	char	prefix,postfix,c,lf=0x0A;
	char	msg[8] = {0x09,0x00,0x08,0x00,0x00,0x00,0x00,0x00};

	bufptr += 1;				/* Skip op code		*/
	p=(void *)&buf[bufptr];
	flgs=*p;
	bufptr += 2;
	procnt = 3;

	uu = flgs & 0x02;
	l  = (flgs & 0x04) >> 2;
	d  = (flgs & 0x08) >> 3;
	b  = (flgs & 0x10) >> 4;
	e  = (flgs & 0x20) >> 5;
	pp = (flgs & 0xC0) >> 6;
	qq = (flgs & 0x300) >> 8;
	s  = (flgs & 0x400) >> 10;
	t  = (flgs & 0x800) >> 11;
	
	prefix = buf[bufptr];
	bufptr += 1;
	postfix = buf[bufptr];
	bufptr += 1;
	procnt += 2;
	output_lost=FALSE;


	if (uu==0) lockflg=FALSE;
	else lockflg=TRUE;

	if (d) discard=FALSE;
	if (pp==1) 
	{
		for (i=0; i < pp; i++) ct_print_char(&lf);
	}
	if (pp==2) ct_print_char(&prefix);


	while (procnt < blklen)
	{
		c=buf[bufptr];
		bufptr += 1;
		procnt += 1;
		ct_print_char(&c);
	}		
	if (qq==1) 
	{
		for (i=0; i < qq; i++) ct_print_char(&lf);
	}
	if (qq==2) ct_print_char(&postfix);

	if (uu==2) lockflg=FALSE;
	if (uu==3)
	{
		lockflg=FALSE;
		redisplay=TRUE;
	}

	if (s==1)
	{
		if (output_lost) msg[3]=0x01;
		if (write(sockfd,msg,8) < 0)
		{
			perror("Write completion");
			ct_reset_term();
			exit(-1);
		}
	}
	if (redisplay)
	{
		redisplay=FALSE;
		for (i=0; i < inpptr; i++)
		{
			if (i < end_of_prompt) ct_echo_prompt(&inpbuf[i]);
			else ct_echo_input_char(&inpbuf[i]);
		}
	}
}
/*-------------------------------------------------------------------------*/
static void ct_readchar_req(void)
{
	char	c;
	short	*p;
	short	selector,procnt,ouptr;
	unsigned char	outbuf[300];

	bufptr += 2;				/* Skip op code 	*/
	procnt = 2;
	outbuf[0] = 0x09;			/* Common data block	*/
	outbuf[1] = 0x00;			/* Flag			*/
	outbuf[4] = 0x0B;
	outbuf[5] = 0x00;

	ouptr = 6;				/* Reserve space for block
						   len field		*/

	while (procnt < blklen)
	{
		p=(void *)&buf[bufptr];		/* Point to selector	*/
		selector=*p;
		if ((selector & 0x300) == 0x000) /* Physical Charac	*/
		{
		   switch (selector & 0xFF)	
		   {
			case 0x01:	/* Input speed			*/
					p=(void *)&outbuf[ouptr];
					*p=0x0001;
					ouptr +=2;
					p=(void *)&outbuf[ouptr];
					*p=phy_char.input_speed;
					ouptr +=2;
					procnt += 2;
					bufptr += 2;
					break;

			case 0x02:	/* Output speed			*/
					p=(void *)&outbuf[ouptr];
					*p=0x0002;
					ouptr +=2;
					p=(void *)&outbuf[ouptr];
					*p=phy_char.output_speed;
					ouptr +=2;
					procnt += 2;
					bufptr += 2;
					break;

			case 0x03:	/* Character size		*/
					p=(void *)&outbuf[ouptr];
					*p=0x0003;
					ouptr +=2;
					p=(void *)&outbuf[ouptr];
					*p=phy_char.character_size;
					ouptr +=2;
					procnt += 2;
					bufptr += 2;
					break;

			case 0x04:	/* Parity enable		*/
					p=(void *)&outbuf[ouptr];
					*p=0x0004;
					ouptr +=2;
					outbuf[ouptr]=phy_char.parity_enable;
					ouptr +=1;
					procnt += 2;
					bufptr += 2;
					break;

			case 0x05:	/* Parity type			*/
					p=(void *)&outbuf[ouptr];
					*p=0x0005;
					ouptr +=2;
					p=(void *)&outbuf[ouptr];
					*p=phy_char.parity_type;
					ouptr +=2;
					procnt += 2;
					bufptr += 2;
					break;

			case 0x06:	/* Modem Present		*/
					p=(void *)&outbuf[ouptr];
					*p=0x0006;
					ouptr +=2;
					outbuf[ouptr]=phy_char.modem_present;
					ouptr +=1;
					procnt += 2;
					bufptr += 2;
					break;

			case 0x07:	/* Auto baud detect		*/
					p=(void *)&outbuf[ouptr];
					*p=0x0007;
					ouptr +=2;
					outbuf[ouptr]=phy_char.auto_baud_detect;
					ouptr +=1;
					procnt += 2;
					bufptr += 2;
					break;

			case 0x08:	/* Management guaranteed	*/
					p=(void *)&outbuf[ouptr];
					*p=0x0008;
					ouptr +=2;
					outbuf[ouptr]=phy_char.management_guaranteed;
					ouptr +=1;
					procnt += 2;
					bufptr += 2;
					break;

			case 0x09:	/* SW 1				*/
					procnt += 2;
					bufptr += 2;
					break;

			case 0x0A:	/* SW 2				*/
					procnt += 2;
					bufptr += 2;
					break;

			case 0x0B:	/* Eight bit			*/
					p=(void *)&outbuf[ouptr];
					*p=0x000B;
					ouptr +=2;
					outbuf[ouptr]=phy_char.eigth_bit;
					ouptr +=1;
					procnt += 2;
					bufptr += 2;
					break;

			case 0x0C:	/* Terminal Management		*/
					p=(void *)&outbuf[ouptr];
					*p=0x000C;
					ouptr +=2;
					outbuf[ouptr]=phy_char.terminal_management_enabled;
					ouptr +=1;
					procnt += 2;
					bufptr += 2;
					break;
		   }
		}
		if ((selector & 0x300) == 0x100) /* Logical Characteristics*/
		{
		   switch(selector & 0xFF)
		   {
			case 0x01:	/* Mode writing allowed		*/
					p=(void *)&outbuf[ouptr];
					*p=0x0101;
					ouptr +=2;
					outbuf[ouptr]=log_char.mode_writing_allowed;
					ouptr +=1;
					procnt += 2;
					bufptr += 2;
					break;
					
			case 0x02:	/* Terminal attributes		*/
					p=(void *)&outbuf[ouptr];
					*p=0x0102;
					ouptr +=2;
					p=(void *)&outbuf[ouptr];
					*p=log_char.terminal_attributes;
					ouptr +=2;
					procnt += 2;
					bufptr += 2;
					break;

			case 0x03:	/* Terminal Type		*/
					p=(void *)&outbuf[ouptr];
					*p=0x0103;
					ouptr +=2;
					p=(void *)&outbuf[ouptr];
					memcpy((void *)p,log_char.terminal_type,6);
					ouptr +=6;
					procnt += 2;
					bufptr += 2;
					break;

			case 0x04:	/* Output flow control		*/
					p=(void *)&outbuf[ouptr];
					*p=0x0104;
					ouptr +=2;
					outbuf[ouptr]=log_char.output_flow_control;
					ouptr +=1;
					procnt += 2;
					bufptr += 2;
					break;

			case 0x05:	/* Output page stop		*/
					p=(void *)&outbuf[ouptr];
					*p=0x0105;
					ouptr +=2;
					outbuf[ouptr]=log_char.output_page_stop;
					ouptr +=1;
					procnt += 2;
					bufptr += 2;
					break;

			case 0x06:	/* Flow char pass through	*/
					p=(void *)&outbuf[ouptr];
					*p=0x0106;
					ouptr +=2;
					outbuf[ouptr]=log_char.flow_character_pass_through;
					ouptr +=1;
					procnt += 2;
					bufptr += 2;
					break;

			case 0x07:	/* Input flow control		*/
					p=(void *)&outbuf[ouptr];
					*p=0x0107;
					ouptr +=2;
					outbuf[ouptr]=log_char.input_flow_control;
					ouptr +=1;
					procnt += 2;
					bufptr += 2;
					break;

			case 0x08:	/* Loss notification		*/
					p=(void *)&outbuf[ouptr];
					*p=0x0108;
					ouptr +=2;
					outbuf[ouptr]=log_char.loss_notification;
					ouptr +=1;
					procnt += 2;
					bufptr += 2;
					break;

			case 0x09:	/* Line width			*/
					p=(void *)&outbuf[ouptr];
					*p=0x0109;
					ouptr +=2;
					p=(void *)&outbuf[ouptr];
					*p=log_char.line_width;
					ouptr +=2;
					procnt += 2;
					bufptr += 2;
					break;

			case 0x0A:	/* Page length			*/
					p=(void *)&outbuf[ouptr];
					*p=0x010A;
					ouptr +=2;
					p=(void *)&outbuf[ouptr];
					*p=log_char.page_length;
					ouptr +=2;
					procnt += 2;
					bufptr += 2;
					break;

			case 0x0B:	/* Stop length			*/
					p=(void *)&outbuf[ouptr];
					*p=0x010B;
					ouptr +=2;
					p=(void *)&outbuf[ouptr];
					*p=log_char.stop_length;
					ouptr +=2;
					procnt += 2;
					bufptr += 2;
					break;

			case 0x0C:	/* CR-FILL			*/
					p=(void *)&outbuf[ouptr];
					*p=0x010C;
					ouptr +=2;
					p=(void *)&outbuf[ouptr];
					*p=log_char.cr_fill;
					ouptr +=2;
					procnt += 2;
					bufptr += 2;
					break;

			case 0x0D:	/* LF-FILL			*/
					p=(void *)&outbuf[ouptr];
					*p=0x010D;
					ouptr +=2;
					p=(void *)&outbuf[ouptr];
					*p=log_char.lf_fill;
					ouptr +=2;
					procnt += 2;
					bufptr += 2;
					break;

			case 0x0E:	/* wrap				*/
					p=(void *)&outbuf[ouptr];
					*p=0x010E;
					ouptr +=2;
					p=(void *)&outbuf[ouptr];
					*p=log_char.wrap;
					ouptr +=2;
					procnt += 2;
					bufptr += 2;
					break;

			case 0x0F:	/* Horizontal tab		*/
					p=(void *)&outbuf[ouptr];
					*p=0x010F;
					ouptr +=2;
					p=(void *)&outbuf[ouptr];
					*p=log_char.horizontal_tab;
					ouptr +=2;
					procnt += 2;
					bufptr += 2;
					break;

			case 0x10:	/* Vertical tab			*/
					p=(void *)&outbuf[ouptr];
					*p=0x0110;
					ouptr +=2;
					p=(void *)&outbuf[ouptr];
					*p=log_char.vertical_tab;
					ouptr +=2;
					procnt += 2;
					bufptr += 2;
					break;

			case 0x11:	/* Form feed			*/
					p=(void *)&outbuf[ouptr];
					*p=0x0111;
					ouptr +=2;
					p=(void *)&outbuf[ouptr];
					*p=log_char.form_feed;
					ouptr +=2;
					procnt += 2;
					bufptr += 2;
					break;
		   }
		}
		if ((selector & 0x300) == 0x200) /* Handler Charact	*/
		{
		   switch (selector & 0xFF)
		   {
			   case 0x01:	/* IGNORE INPUT 		*/
					p=(void *)&outbuf[ouptr];
					*p=0x0201;
					ouptr += 2;
					outbuf[ouptr]=han_char.ignore_input;
					ouptr += 1;
					procnt += 2;
					bufptr += 2;
					break;
			   case 0x02:	/* Character Attributes 	*/
					p=(void *)&outbuf[ouptr];
					*p=0x0202;
					ouptr += 2;
					bufptr += 1;
					c=buf[bufptr];
					outbuf[ouptr]=c;
					outbuf[ouptr+1]=0xFF;
					outbuf[ouptr+2]=char_attr[c];
					ouptr += 3;
					procnt += 3;
					bufptr += 3;
					break;
			   case 0x03:	/* Control-o pass through 	*/
					p=(void *)&outbuf[ouptr];
					*p=0x0203;
					ouptr += 2;
					outbuf[ouptr]=han_char.control_o_pass_through;
					ouptr += 1;
					procnt += 2;
					bufptr += 2;
					break;

			   case 0x04:	/* Raise Input			*/
					p=(void *)&outbuf[ouptr];
					*p=0x0204;
					ouptr += 2;
					outbuf[ouptr]=han_char.raise_input;
					ouptr += 1;
					procnt += 2;
					bufptr += 2;
					break;

			   case 0x05:	/* Normal Echo			*/
					p=(void *)&outbuf[ouptr];
					*p=0x0205;
					ouptr += 2;
					outbuf[ouptr]=han_char.normal_echo;
					ouptr += 1;
					procnt += 2;
					bufptr += 2;
					break;

			   case 0x06:	/* Input Escape Seq Recognition */
					p=(void *)&outbuf[ouptr];
					*p=0x0206;
					ouptr += 2;
					outbuf[ouptr]=han_char.input_escseq_recognition;
					ouptr += 1;
					procnt += 2;
					bufptr += 2;
					break;

			   case 0x07:	/* Output Esc Seq Recognition	*/
					p=(void *)&outbuf[ouptr];
					*p=0x0207;
					ouptr += 2;
					outbuf[ouptr]=han_char.output_escseq_recognition;
					ouptr += 1;
					procnt += 2;
					bufptr += 2;
					break;

			   case 0x08:	/* Input count state		*/
					p=(void *)&outbuf[ouptr];
					*p=0x0208;
					ouptr += 2;
					p=(void *)&outbuf[ouptr];
					*p=han_char.input_count_state;
					ouptr += 2;
					procnt += 2;
					bufptr += 2;
					break;

			   case 0x09:	/* Auto Prompt			*/
					p=(void *)&outbuf[ouptr];
					*p=0x0209;
					ouptr += 2;
					outbuf[ouptr]=han_char.auto_prompt;
					ouptr += 1;
					procnt += 2;
					bufptr += 2;
					break;

			   case 0x0A:	/* Error processing option	*/
					p=(void *)&outbuf[ouptr];
					*p=0x020A;
					ouptr += 2;
					outbuf[ouptr]=han_char.error_processing;
					ouptr += 1;
					procnt += 2;
					bufptr += 2;
					break;
			}
		}
	}
	p=(void *)&outbuf[2];
	*p=ouptr - 6;
	if (write(sockfd,outbuf,ouptr) < 0)
	{
		perror("Error writing characteristics");
		ct_reset_term();
		exit(-1);
	}
}
/*-------------------------------------------------------------------------*/
static void ct_writechar_req(void)
{
	char	c;
	short	*p;
	short	selector, procnt;

	bufptr += 2;				/* Skip op code		*/
	procnt = 2;
	while (procnt < blklen)
	{
		p=(void *)&buf[bufptr];		/* Point to selector	*/
		selector=*p;
		if ((selector & 0x300) != 0x200)
		{
			bufptr=cnt; procnt=blklen;
			break;
		}
		selector &= 0xFF;
		bufptr += 2;			/* Point to selector value */
		switch(selector)
		{

		   case 0x01:	/* IGNORE INPUT 		*/
				han_char.ignore_input = buf[bufptr];
				procnt += 3;
				bufptr += 1;
				break;
		   case 0x02:	/* Character Attributes 	*/
				c=buf[bufptr];
				if (buf[bufptr+1] & 0x03)
				   char_attr[c] |= (buf[bufptr+2] & 0x03);
				if (buf[bufptr+1] & 0x04)
				   char_attr[c] |= (buf[bufptr+2] & 0x04);
				if (buf[bufptr+1] & 0x08)
				   char_attr[c] |= (buf[bufptr+2] & 0x08);
				if (buf[bufptr+1] & 0x30)
				   char_attr[c] |= (buf[bufptr+2] & 0x30);
				if (buf[bufptr+1] & 0x40)
				   char_attr[c] |= (buf[bufptr+2] & 0x40);
				procnt += 5;
				bufptr += 3;
				break;
		   case 0x03:	/* Control-o pass through 	*/
				han_char.control_o_pass_through = buf[bufptr];
				procnt += 3;
				bufptr += 1;
				break;
		   case 0x04:	/* Raise Input			*/
				han_char.raise_input = buf[bufptr];
				procnt += 3;
				bufptr += 1;
				break;
		   case 0x05:	/* Normal Echo			*/
				han_char.normal_echo = buf[bufptr];
				procnt += 3;
				bufptr += 1;
				break;

		   case 0x06:	/* Input Escape Seq Recognition */
				han_char.input_escseq_recognition = buf[bufptr];
				procnt += 3;
				bufptr += 1;
				break;

		   case 0x07:	/* Output Esc Seq Recognition	*/
				han_char.output_escseq_recognition=buf[bufptr];
				procnt += 3;
				bufptr += 1;
				break;

		   case 0x08:	/* Input count state		*/
				p=(void *)&buf[bufptr];
				han_char.input_count_state = *p;
				procnt += 4;
				bufptr += 2;
				break;

		   case 0x09:	/* Auto Prompt			*/
				han_char.auto_prompt = buf[bufptr];
				procnt += 3;
				bufptr += 1;
				break;

		   case 0x0A:	/* Error processing option	*/
				han_char.error_processing = buf[bufptr];
				procnt += 3;
				bufptr += 1;
				break;
		}
	}
}
/*-------------------------------------------------------------------------*/
static void ct_checkinput_req(void)
{
	unsigned char	msg[8] = {0x09,0x00,0x04,0x00,0x0D,0x00,0x00,0x00};
	short 	*p = (void *)&msg[4];

	*p=aheadcnt+inpcnt;
	if (write(sockfd,msg,8) < 0)
	{
		perror("input count msg");
		ct_reset_term();
		exit(-1);
	}
}
/*-------------------------------------------------------------------------*/
static void ct_read_pkt(void)
{

	while ( (cnt=read(sockfd,buf,sizeof(buf))) < 0);
/*
	if ( (cnt=read(sockfd,buf,sizeof(buf))) < 0)
	{
		perror("read pkt");
		ct_reset_term();
		exit(-1);
	}
*/
	if (buf[0] == 0x09) bufptr = 2;
	if (buf[0] == 0x02) unbind = TRUE;

}
/*-------------------------------------------------------------------------*/
static void ct_proc_pkt(void)
{
	short	*p;

	if (cnt==bufptr) ct_read_pkt();		/* Get next pkt    */
	while (!unbind)
	{
		p=(void *)&buf[bufptr];
		blklen=*p;
		bufptr += 2;	
		switch(buf[bufptr])
		{
			case 0x02:		/* Start Read 		*/
				   ct_read_req();
				   break;
			case 0x05:		/* Unread		*/
				   ct_unread_req();
				   break;
			case 0x06:		/* Clear Input		*/
				   ct_clearinput_req();
				   break;
			case 0x07:		/* Write		*/
				   ct_write_req();
				   break;
			case 0x0A:		/* Read Characteristics */
				   ct_readchar_req();
				   break;
			case 0x0B:		/* Write Characteristics*/
				   ct_writechar_req();
				   break;
			case 0x0C:		/* Check Input		*/
				   ct_checkinput_req();
				   break;
			default:
				bufptr = cnt;
		}
		if (cnt==bufptr) ct_read_pkt();
	}
	printf("\n\nReturned to local host.\n");
}
/*-------------------------------------------------------------------------*/
main(argc, argv)
	int	argc;
	char	*argv[];
{

	if (argc < 2) {
		printf("Usage: sethost nodename\n");
		exit();
	}
	sprintf(nodename,"%s",argv[1]);

	ct_setup();				/* Resolve remote node addr*/	
	ct_setup_link();			/* Setup link		   */

	ct_init_term();				/* Set terminal in raw mode*/

	signal(SIGIO,ct_preinput_proc);		/* Setup SIGIO Handler for 
       						   keyboard input          */
	signal(SIGALRM,ct_timeout_proc);
	alarm(0);

	ct_proc_pkt();				/* Process input packets   */

	ct_reset_term();
}
