/*
   sound/ms32fxKernel.c

   Not PnP Maxisound32FX software configuration routines,
   Copyright (C) 1997  Vincent Labie (sorry, no fixed email!)
   writen from Audio Excel DSP 16 software configuration routines
   Copyright (C) 1995  Riccardo Facchetti (riccardo@cdc8g5.cdc.polimi.it)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/************************************************************************************************/
/*	Include the main USS/Lite header file. It include all the os, USS/Lite, etc		*/
/*	headers needed by this source.								*/

#include <linux/config.h>
#include "../sound_config.h"
#include <linux/delay.h>

#ifdef	CONFIG_MS32FX
/************************************************************************************************/

#if	(defined(CONFIG_MS32FX_SBPRO)&&defined(CONFIG_MS32FX_MSS))
 #error You have to enable only one of the MSS and SBPRO emulations.
#endif

#include "ms32fxCommon.h"

/************************************************************************************************/

#define	MS32FX_SBBASE	0x220

#ifndef	CONFIG_MS32FX_SBPRO
 #define CONFIG_MS32FX_SBPRO		0
 #undef  MS32FX_SBC_IRQ
 #define MS32FX_SBC_IRQ			0
 #undef  MS32FX_SBC_DMA
 #define MS32FX_SBC_DMA			0
#endif

#ifndef	CONFIG_MS32FX_MSS
 #define CONFIG_MS32FX_MSS		0
 #undef  MS32FX_MSSBASE
 #define MS32FX_MSSBASE			0
 #undef  MS32FX_MSS_IRQ
 #define MS32FX_MSS_IRQ			0
 #undef  MS32FX_MSS_DMA
 #define MS32FX_MSS_DMA			0
#endif

#ifndef	CONFIG_MS32FX_MPU401
 #define CONFIG_MS32FX_MPU401		0
 #undef  MS32FX_MPUBASE
 #define MS32FX_MPUBASE			0
 #undef  MS32FX_MPU_IRQ
 #define MS32FX_MPU_IRQ			0
#endif

#ifndef	CONFIG_MS32FX_JOY
 #define CONFIG_MS32FX_JOY		0
#endif

#ifndef	MS32FX_CDROMTYPE
 #define MS32FX_CDROMTYPE		4
 #undef  MS32FX_CDROMBASE
 #define MS32FX_CDROMBASE		0
#endif

int	verbose=0;

MS32FXPROGHARDCFG	MS32FXProgHardCfg;
MS32FXHARDCFG		MS32FXHardCfg;

/************************************************************************************************/
	void	DBGf(char * szFormat)
{	if (verbose>1) printk(szFormat);	}
	void	DBGfs(char * szFormat,char * szText)
{	if (verbose>1) printk(szFormat,szText);	}
	void	DBGfi(char * szFormat,int val)
{	if (verbose>1) printk(szFormat,val);	}
	void	DBGfic(char * szFormat,int val,char c)
{	if (verbose>1) printk(szFormat,val,c);	}
	void	DBGfii(char * szFormat,int val,int val2)
{	if (verbose>1) printk(szFormat,val,val2);	}

	void	WARf(char * szFormat)
{	if (verbose>0) printk(szFormat);	}
	void	WARfi(char * szFormat,int val)
{	if (verbose>0) printk(szFormat,val);	}

	void	ERRf(char * szFormat)
{	printk(szFormat);	}
	void	ERRfs(char * szFormat,char * szText)
{	printk(szFormat,szText);	}
	void	ERRfi(char * szFormat,int val)
{	printk(szFormat,val);	}

/************************************************************************************************/
/************************************************************************************************/
/************************************************************************************************/
/************************************************************************************************/
/************************************************************************************************/
/************************************************************************************************/

/************************************************************************************************/
void	MS32FXudelay(int usec)
{	udelay(usec);	}

/************************************************************************************************/
static	int	init_ms32fx_sb(void)
{
	if (CONFIG_MS32FX_SBPRO==0) return(TRUE);
	DBGf("init_ms32fx_sb: ");
	DBGfi("[Maxisound32FX] Info init state : %i\n",MS32FXHardCfg.InitState);
	if (MS32FXHardCfg.InitState&INIT_MSS)
		{ ERRf("card already initialized in mss!\n"); return(FALSE); }
	if (MS32FXHardCfg.InitState&INIT_SBPRO)
		{ ERRf("card already initialized in sbpro!\n"); return(TRUE); }
	MS32FXHardCfg.InitState|=INIT_SBPRO;
	DBGf("done.\n");
	return(TRUE);
}

/************************************************************************************************/
static	void	uninit_ms32fx_sb(void)
{
	if (CONFIG_MS32FX_SBPRO==0) return;
	DBGf("uninit_ms32fx_sb: ");
	DBGfi("[Maxisound32FX] Info init state : %i\n",MS32FXHardCfg.InitState);
	MS32FXHardCfg.InitState&=~INIT_SBPRO;
	DBGf("done.\n");
}

/************************************************************************************************/
static	int	init_ms32fx_mss(void)
{
	if (CONFIG_MS32FX_MSS==0) return(TRUE);
	DBGf("init_ms32fx_mss: ");
	DBGfi("[Maxisound32FX] Info init state : %i\n",MS32FXHardCfg.InitState);
	if (MS32FXHardCfg.InitState&INIT_SBPRO)
		{ ERRf("card already initialized in sbpro!\n"); return(FALSE); }
	if (MS32FXHardCfg.InitState&INIT_MSS)
		{ ERRf("card already initialized in mss!\n"); return(TRUE); }
	if ((MS32FXHardCfg.InitState&INIT_MPU401)==0)
		if (check_region(MS32FXProgHardCfg.sbbase,0x0f))
			{ ERRf("MS32FX BASE I/O port region is already in use.\n");
			return(FALSE); }
	if ((MS32FXHardCfg.InitState&INIT_MPU401)==0)
		request_region(MS32FXProgHardCfg.sbbase,0x0f,"MS32FX (base)");
	MS32FXHardCfg.InitState|=INIT_MSS;
	DBGf("done.\n");
	return(TRUE);
}

/************************************************************************************************/
static	void	uninit_ms32fx_mss(void)
{
	if (CONFIG_MS32FX_MSS==0) return;
	DBGf("uninit_ms32fx_mss: ");
	DBGfi("[Maxisound32FX] Info init state : %i\n",MS32FXHardCfg.InitState);
	if (((MS32FXHardCfg.InitState&INIT_MPU401)==0)&&(MS32FXHardCfg.InitState&INIT_MSS))
		release_region(MS32FXProgHardCfg.sbbase,0x0f);
	MS32FXHardCfg.InitState&=~INIT_MSS;
	DBGf("done.\n");
}

/************************************************************************************************/
static	int	init_ms32fx_mpu(void)
{
	if (CONFIG_MS32FX_MPU401==0) return(TRUE);
	DBGf("init_ms32fx_mpu: ");
	DBGfi("[Maxisound32FX] Info init state : %i\n",MS32FXHardCfg.InitState);
	if (MS32FXHardCfg.InitState&INIT_MPU401) return(FALSE);
	if ((MS32FXHardCfg.InitState&(INIT_MSS|INIT_SBPRO))==0)
		if (check_region(MS32FXProgHardCfg.sbbase,0x0f))
			{ ERRf("MS32FX BASE I/O port region is already in use.\n");
			return(FALSE); }
	if ((MS32FXHardCfg.InitState&(INIT_MSS|INIT_SBPRO))==0)
		request_region(MS32FXProgHardCfg.sbbase,0x0f,"MS32FX (base)");
	MS32FXHardCfg.InitState|=INIT_MPU401;
	DBGf("done.\n");
	return TRUE;
}

/************************************************************************************************/
static	void	uninit_ms32fx_mpu(void)
{
	if (CONFIG_MS32FX_MPU401==0) return;
	DBGf("uninit_ms32fx_mpu: ");
	DBGfi("[Maxisound32FX] Info init state : %i\n",MS32FXHardCfg.InitState);
	if (((MS32FXHardCfg.InitState&(INIT_MSS|INIT_SBPRO))==0)&&
	   (MS32FXHardCfg.InitState&INIT_MPU401))
		release_region(MS32FXProgHardCfg.sbbase,0x0f);

	MS32FXHardCfg.InitState&=~INIT_MPU401;
	DBGf("done.\n");
}

/************************************************************************************************/
static	void	InitProgHardParameters(void)
{
/*		Now set up the real kernel configuration.					*/
	MS32FXProgHardCfg.sbbase	=MS32FX_SBBASE;
	MS32FXProgHardCfg.mss		=(CONFIG_MS32FX_MSS!=0);
	MS32FXProgHardCfg.mssbase	=MS32FX_MSSBASE;
	MS32FXProgHardCfg.mpu		=(CONFIG_MS32FX_MPU401!=0);
	MS32FXProgHardCfg.mpubase	=MS32FX_MPUBASE;
 	MS32FXProgHardCfg.joystick	=(CONFIG_MS32FX_JOY!=0);
	MS32FXProgHardCfg.cdrom		=(MS32FX_CDROMTYPE!=4)&&(MS32FX_CDROMBASE!=0);
	MS32FXProgHardCfg.cdromtype	=MS32FX_CDROMTYPE;
	MS32FXProgHardCfg.cdrombase	=MS32FX_CDROMBASE;
	MS32FXProgHardCfg.irq		=(CONFIG_MS32FX_MSS)?MS32FX_MSS_IRQ:MS32FX_SBC_IRQ;
	MS32FXProgHardCfg.mpuirq	=MS32FX_MPU_IRQ;
	MS32FXProgHardCfg.dma		=(CONFIG_MS32FX_MSS)?MS32FX_MSS_DMA:MS32FX_SBC_DMA;
}

/************************************************************************************************/
int	init_ms32fx(void)
{
	int		initialized=FALSE;

	InitProgHardParameters();

	DBGfi("Initializing BASE[0x%03X] ",	MS32FXProgHardCfg.sbbase);
	DBGfi("IRQ[%d] ",			MS32FXProgHardCfg.irq);
	DBGfi("DMA[%d] ",			MS32FXProgHardCfg.dma);
	DBGfi("MIRQ[%d]\n",			MS32FXProgHardCfg.mpuirq);

	if (init_ms32fx_sb()==FALSE)	uninit_ms32fx_sb();
	else				initialized=TRUE;
	if (init_ms32fx_mpu()==FALSE)	uninit_ms32fx_mpu();
	else				initialized=TRUE;
	if (init_ms32fx_mss()==FALSE)	uninit_ms32fx_mss();
	else				initialized=TRUE;

	if (initialized)	initialized=InitMS32FX();
	if (initialized==FALSE)	DisableBoard();
	return(initialized);
}

/************************************************************************************************/
void	uninit_ms32fx(void)
{
	DBGf("[[MaxiSound32FX]] call WriteHardIRQDMA\n");
	if (WriteHardIRQDMA()==FALSE)
		WARf("[MaxiSound32FX] Warning: WriteHardIRQDMA Failed.");
	MS32FXHardCfg.HardCfg=MS32FXHardCfg.PrevHardCfg;
	DBGf("[[MaxiSound32FX]] call WriteHardCfg\n");
	if (WriteHardCfg(MS32FXHardCfg.HardCfg)==FALSE)
		WARf("[MaxiSound32FX] Warning: WriteHardCfg: failed.\n");
	DBGf("[[MaxiSound32FX]] call DisableBoard\n");
	DisableBoard();
	uninit_ms32fx_mss();
	uninit_ms32fx_sb();
	uninit_ms32fx_mpu();
}

/************************************************************************************************/

#endif	/* CONFIG_MS32FX */
