/*
   sound/ms32fxExec.c

   Not PnP Maxisound32FX software configuration routines,
   Copyright (C) 1997  Vincent Labie (sorry, no fixed email!)
   writen from Audio Excel DSP 16 software configuration routines
   Copyright (C) 1995  Riccardo Facchetti (riccardo@cdc8g5.cdc.polimi.it)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/************************************************************************************************/
/*	headers needed by this source.								*/

#include <stdio.h>
#include <unistd.h>
#include <asm/io.h>
#include "ms32fxCommon.h"

/************************************************************************************************/

int	verbose=0;

MS32FXPROGHARDCFG	MS32FXProgHardCfg;
extern	MS32FXHARDCFG	MS32FXHardCfg;

/************************************************************************************************/
	void	DBGf(char * szFormat)
{	if (verbose>1) printf(szFormat);	}
	void	DBGfs(char * szFormat,char * szText)
{	if (verbose>1) printf(szFormat,szText);	}
	void	DBGfi(char * szFormat,int val)
{	if (verbose>1) printf(szFormat,val);	}
	void	DBGfic(char * szFormat,int val,char c)
{	if (verbose>1) printf(szFormat,val,c);	}
	void	DBGfii(char * szFormat,int val,int val2)
{	if (verbose>1) printf(szFormat,val,val2);	}

	void	WARf(char * szFormat)
{	if (verbose>0) printf(szFormat);	}
	void	WARfi(char * szFormat,int val)
{	if (verbose>0) printf(szFormat,val);	}

	void	ERRf(char * szFormat)
{	printf(szFormat);	}
	void	ERRfs(char * szFormat,char * szText)
{	printf(szFormat,szText);	}
	void	ERRfi(char * szFormat,int val)
{	printf(szFormat,val);	}

/************************************************************************************************/
/************************************************************************************************/
/************************************************************************************************/
/************************************************************************************************/
/************************************************************************************************/
/************************************************************************************************/

/************************************************************************************************/
void	MS32FXudelay(int usec)
{	int	i;	for (i=0;i<usec;i++) outb(0,0x80);	}

/************************************************************************************************/

int	main(int argc,char **argv)
{
	int			c;
	extern	char *		optarg;

	MS32FXProgHardCfg.sbbase	=0x220;
	MS32FXProgHardCfg.mss		=1;
	MS32FXProgHardCfg.mssbase	=0x530;
	MS32FXProgHardCfg.mpu		=0;
	MS32FXProgHardCfg.mpubase	=0x330;
 	MS32FXProgHardCfg.joystick	=0;
	MS32FXProgHardCfg.cdrom		=0;
	MS32FXProgHardCfg.cdromtype	=4;
	MS32FXProgHardCfg.cdrombase	=0x300;
	MS32FXProgHardCfg.irq		=0;
	MS32FXProgHardCfg.mpuirq	=0;
	MS32FXProgHardCfg.dma		=1;

	while(((c=getopt(argc,argv,"?hv:si:d:w:q:m:t:c:g"))!=EOF))
		switch(c)
			{
			case '?':
			case 'h':
				printf("ms32fxInit options: (default)\n");
				printf(" -h             : Help, amazing, no?\n");
				printf(" -v val (0)     : Verbose level val=0(quiet),1(warning),2(anything!)\n");
				printf(" -s             : SB emulation (default:WSS emulation)\n");
				printf(" -i val (5)     : IRQ val=7,9,10,11 or 5 only for sb emulation\n");
				printf(" -d val (1)     : DMA val=0,1,3\n");
				printf(" -w val (0x530) : WSS base val=0x530,0xE80\n");
				printf(" -q val (0)     : MPU IRQ val=5,7,9,10,0 (disable)\n");
				printf(" -m val (0x330) : MPU base val=0x300,0x310,0x320,0x330\n");
				printf(" -t val (4)     : CDROM type val=0(Sony???),1(Panasonic),2(G???),3(IDE),4(disable)\n");
				printf(" -c val (0x300) : CDROM base val=0x300,0x310,...,0x370\n");
				printf(" -g             : Enable joystick port (default:disable)\n");
				printf(" You  must at least set the irq.\n");
				exit(0);
			case 'v':
				if (strcmp(optarg,"0")==0)	{ verbose=0; break; }
				if (strcmp(optarg,"1")==0)	{ verbose=1; break; }
				if (strcmp(optarg,"2")==0)	{ verbose=3; break; }
				printf("Error: invalide verbose level: %s\n try help option -h.\n",optarg);
				exit(1);
				break;
			case 's':
				MS32FXProgHardCfg.mss=0;
				break;
			case 'i':
				if (strcmp(optarg,"5")==0)	{ MS32FXProgHardCfg.irq=5; break; }
				if (strcmp(optarg,"7")==0)	{ MS32FXProgHardCfg.irq=7; break; }
				if (strcmp(optarg,"9")==0)	{ MS32FXProgHardCfg.irq=9; break; }
				if (strcmp(optarg,"10")==0)	{ MS32FXProgHardCfg.irq=10; break; }
				if (strcmp(optarg,"11")==0)	{ MS32FXProgHardCfg.irq=11; break; }
				printf("Error: invalide irq: %s\n try help option -h.\n",optarg);
				exit(1);
				break;
			case 'd':
				if (strcmp(optarg,"0")==0)	{ MS32FXProgHardCfg.dma=0; break; }
				if (strcmp(optarg,"1")==0)	{ MS32FXProgHardCfg.dma=1; break; }
				if (strcmp(optarg,"3")==0)	{ MS32FXProgHardCfg.dma=3; break; }
				printf("Error: invalide dma: %s\n try help option -h.\n",optarg);
				exit(1);
				break;
			case 'w':
				if (strcmp(optarg,"0x530")==0)	{ MS32FXProgHardCfg.mssbase=0x530; break; }
				if (strcmp(optarg,"0xE80")==0)	{ MS32FXProgHardCfg.mssbase=0xE80; break; }
				printf("Error: invalide WSS base: %s\n try help option -h.\n",optarg);
				exit(1);
				break;
			case 'q':
				if (strcmp(optarg,"0")==0)	{ MS32FXProgHardCfg.mpuirq=0; break; }
				if (strcmp(optarg,"5")==0)	{ MS32FXProgHardCfg.mpuirq=5; break; }
				if (strcmp(optarg,"7")==0)	{ MS32FXProgHardCfg.mpuirq=7; break; }
				if (strcmp(optarg,"9")==0)	{ MS32FXProgHardCfg.mpuirq=9; break; }
				if (strcmp(optarg,"10")==0)	{ MS32FXProgHardCfg.mpuirq=10; break; }
				printf("Error: invalide irq: %s\n try help option -h.\n",optarg);
				exit(1);
				break;
			case 'm':
				if (strcmp(optarg,"0x300")==0)	{ MS32FXProgHardCfg.mpubase=0x300; break; }
				if (strcmp(optarg,"0x310")==0)	{ MS32FXProgHardCfg.mpubase=0x310; break; }
				if (strcmp(optarg,"0x320")==0)	{ MS32FXProgHardCfg.mpubase=0x320; break; }
				if (strcmp(optarg,"0x330")==0)	{ MS32FXProgHardCfg.mpubase=0x330; break; }
				printf("Error: invalide MPU401 base: %s\n try help option -h.\n",optarg);
				exit(1);
				break;
			case 't':
				if (strcmp(optarg,"0")==0)	{ MS32FXProgHardCfg.cdromtype=0; break; }
				if (strcmp(optarg,"1")==0)	{ MS32FXProgHardCfg.cdromtype=1; break; }
				if (strcmp(optarg,"3")==0)	{ MS32FXProgHardCfg.cdromtype=3; break; }
				if (strcmp(optarg,"4")==0)	{ MS32FXProgHardCfg.cdromtype=4; break; }
				printf("Error: invalide CDROM type: %s\n try help option -h.\n",optarg);
				exit(1);
				break;
			case 'c':
				if (strcmp(optarg,"0x300")==0)	{ MS32FXProgHardCfg.cdrombase=0x300; break; }
				if (strcmp(optarg,"0x310")==0)	{ MS32FXProgHardCfg.cdrombase=0x310; break; }
				if (strcmp(optarg,"0x320")==0)	{ MS32FXProgHardCfg.cdrombase=0x320; break; }
				if (strcmp(optarg,"0x330")==0)	{ MS32FXProgHardCfg.cdrombase=0x330; break; }
				if (strcmp(optarg,"0x340")==0)	{ MS32FXProgHardCfg.cdrombase=0x340; break; }
				if (strcmp(optarg,"0x350")==0)	{ MS32FXProgHardCfg.cdrombase=0x350; break; }
				if (strcmp(optarg,"0x360")==0)	{ MS32FXProgHardCfg.cdrombase=0x360; break; }
				if (strcmp(optarg,"0x370")==0)	{ MS32FXProgHardCfg.cdrombase=0x370; break; }
				printf("Error: invalide CDROM base: %s\n try help option -h.\n",optarg);
				exit(1);
				break;
			case 'g':
				MS32FXProgHardCfg.joystick=1;
				break;
			}
	if (MS32FXProgHardCfg.irq==0)
		{ printf(" You  must at least set the MSS/SB irq. Maxisound32FX not initialized.\n"); exit(1); }
	if ((MS32FXProgHardCfg.mss==1)&&(MS32FXProgHardCfg.irq==5))
		{ printf("Error: irq 5 can't be used in WSS emulation.\n"); exit(1); }
	if (MS32FXProgHardCfg.cdromtype!=4) MS32FXProgHardCfg.cdrom=1;
	if (MS32FXProgHardCfg.mpuirq!=0) MS32FXProgHardCfg.mpu=1;

	if (MS32FXProgHardCfg.mss)
		MS32FXHardCfg.InitState|=INIT_MSS;
	else	MS32FXHardCfg.InitState|=INIT_SBPRO;
	if (MS32FXProgHardCfg.mpu)
		MS32FXHardCfg.InitState|=INIT_MPU401;
	if (iopl(3)==-1) { printf("Error: iopl failed.\n"); exit(1); }

	DBGfi("WSS mode   : %i\n",MS32FXProgHardCfg.mss);
	DBGfi("WSS base   : 0x%03X\n",MS32FXProgHardCfg.mssbase);
	DBGfi("IRQ        : %i\n",MS32FXProgHardCfg.irq);
	DBGfi("DMA        : %i\n",MS32FXProgHardCfg.dma);
	DBGfi("MPU mode   : %i\n",MS32FXProgHardCfg.mpu);
	DBGfi("MPU IRQ    : %i\n",MS32FXProgHardCfg.mpuirq);
	DBGfi("MPU base   : 0x%03X\n",MS32FXProgHardCfg.mpubase);
	DBGfi("JOYSTICK   : %i\n",MS32FXProgHardCfg.joystick);
	DBGfi("CDROM      : %i\n",MS32FXProgHardCfg.cdrom);
	DBGfi("CDROM type : %i\n",MS32FXProgHardCfg.cdromtype);
	DBGfi("CDROM base : 0x%03X\n",MS32FXProgHardCfg.cdrombase);

	DBGf("[[MaxiSound32FX]] call WriteHardIRQDMA\n");
	if (WriteHardIRQDMA()==FALSE)
		WARf("[MaxiSound32FX] Warning: WriteHardIRQDMA Failed.");
	DBGf("[[MaxiSound32FX]] call WriteHardCfg\n");
	if (WriteHardCfg(MS32FXHardCfg.HardCfg)==FALSE)
		WARf("[MaxiSound32FX] Warning: WriteHardCfg: failed.\n");

	if (InitMS32FX()==FALSE)
		{ printf("Error: initialisation failed.\n"); exit(1); }
	iopl(0);
	return(0);
}
