#define	VERSION			"0.0.2"		/*	Version of Maxisound32FX driver		*/

/************************************************************************************************/
/*		Misc definitions								*/

#define TRUE			1
#define FALSE			0

/************************************************************************************************/
/*		Hardware related defaults							*/

#define	DEF_MS32FX_SBIOB	0x220		/*	0x220(default) 0x240			*/
#define	DEF_MS32FX_MSSIOB	0x530		/*	0x530(default) 0xE80			*/
#define	DEF_MS32FX_MPUIOB	0x330		/*	0x330(default) 0x3x0 (x=0,1,2,3)	*/
#define	DEF_MS32FX_IRQ		7		/*	5 7(default) 9 10 11			*/
#define	DEF_MS32FX_MPUIRQ	0		/*	5 7 9 10 0(default), 0 means disable	*/
#define	DEF_MS32FX_DMA		1		/*	0 1(default) 3				*/

/************************************************************************************************/
/*		Commands of MS32FX's DSP (SBPRO+special).					*/
/*		Some of them are COMMAND_xx, in the future they may change.			*/

#define DSP_WRITE_IRQDMA_50	0x50		/*	Set M&I&DRQ mask (the real config)	*/
#define DSP_READ_HCFG_58	0x58		/*	Read Hardware Config (I/O base etc)	*/
#define DSP_START_W_TRANSFER_5C	0x5c		/*						*/
#define COMMAND_60		0x60		/*						*/
#define DSP_WRITE_HARDCFG_6C	0x6c		/*						*/
#define DSP_RESET_TO_SB_88	0x88		/*						*/
#define DSP_INIT_MSS_MODE_8C	0x8c		/*	Enable Microsoft Sound System mode	*/
#define DSP_END_W_TRANSFER_C5	0xc5		/*						*/
#define GET_DSP_VERSION_E1	0xe1		/*	Get DSP Version				*/
#define GET_DSP_COPYRIGHT_E3	0xe3		/*	Get DSP Copyright			*/

/************************************************************************************************/
/*		Offsets of MS32FX DSP I/O ports. The offset is added to base I/O port		*/
/*		to have the actual I/O port.							*/
/*		Register permissions are:							*/
/*						(wo) == Write Only				*/
/*						(ro) == Read  Only				*/
/*						(w-) == Write					*/
/*						(r-) == Read					*/

#define	DSP_LDATA		0x04
#define	DSP_HDATA		0x05
#define DSP_RESET		0x06		/*	offset of DSP RESET		(wo)	*/
#define DSP_READ		0x0a		/*	offset of DSP READ		(ro)	*/
#define DSP_WRITE		0x0c		/*	offset of DSP WRITE		(w-)	*/
#define DSP_COMMAND		0x0c		/*	offset of DSP COMMAND		(w-)	*/
#define DSP_STATUS		0x0c		/*	offset of DSP STATUS		(r-)	*/
#define DSP_DATAVAIL		0x0e		/*	offset of DSP DATA AVAILABLE	(ro)	*/

#define MSS_LDATA		0x04
#define MSS_HDATA		0x05

#define RETRY			10		/* Various retry values on I/O operations.	*/
#define RESETRETRY		25
#define WAITRETRY		1000
#define LONGWAITRETRY		10
#define WRITERETRY		100000
#define	DELAYWRITEDATA1		1
#define	DELAYWRITEDATA2		2
#define MPUWRITERETRY		300000		/*	Yaoo... impressive, isn't it?		*/
#define MPUREADRETRY		300000		/*	but, that's live...			*/

/************************************************************************************************/
/*		Size of character arrays that store name and version of sound card		*/

#define	CARDNAMELEN		15		/*	Size of the card's name in chars	*/
#define	CARDVERLEN		2		/*	Size of the card's version in chars	*/

/************************************************************************************************/
/*		Bit mapped flags for calling InitMS32FX(), and saving the current 		*/
/*		emulation mode.									*/

#define INIT_NONE		(0   )
#define INIT_SBPRO		(1   )
#define INIT_MSS		(1<<1)
#define INIT_MPU401		(1<<2)

/************************************************************************************************/
/*		Wanted hard configuration							*/

typedef	struct
	{
	int		sbbase;
	int		joystick;
	int		mpu;
	int		mpubase;
	int		mss;
	int		mssbase;
	int		cdrom;
	int		cdromtype;
	int		cdrombase;
	int		irq;			/*	irq value for DSP I/O			*/
	int		mpuirq;			/*	irq for mpu401 interface I/O		*/
	int		dma;			/*	dma value for DSP I/O			*/
	}	MS32FXPROGHARDCFG;

/************************************************************************************************/
/*		orVals contain the values to be or'ed						*/

typedef	struct
	{
	int		val;			/*	irq|mirq|dma				*/
	int		or;			/*	SBIrqDmaCfg |= TheStruct.or		*/
	}	ORVALS;

/************************************************************************************************/
/*		Bit mapped flags for calling InitMS32FX(), and saving the current 		*/
/*		emulation mode.									*/

#define INIT_NONE		(0   )
#define INIT_SBPRO		(1   )
#define INIT_MSS		(1<<1)
#define INIT_MPU401		(1<<2)

/************************************************************************************************/
/*		MS32FXHardCfg contain the audio card configuration				*/

typedef	struct
	{
	int		sbbase;			/*	base I/O address for accessing card	*/
	int		mssbase;		/*	base I/O address for accessing card	*/
	int		mpubase;		/*	base I/O address for accessing card	*/
	int		PrevHardCfg;
	int		HardCfg;
	int		InitState;		/*	Initialization status of the card	*/
	int		HardDSPVersion;
	int		HardDSPSubVersion;
	int		SBIrqDmaCfg;		/*	Will contain or'ed values of soft cf	*/
	int		MSSIrqDmaCfg;		/*	Will contain or'ed values of some cf	*/
	int		Version[2];		/*	DSP Version, hi<-ver[0], lo<-ver[1]	*/
	}	MS32FXHARDCFG;

/************************************************************************************************/

void	MS32FXudelay(int usec);

int	DisableBoard(void);
int	WriteHardIRQDMA(void);
int	WriteHardCfg(int iWriteHardCfg);
int	InitMS32FX(void);

