/*
   sound/ms32fxCommon.c

   Not PnP Maxisound32FX software configuration routines,
   Copyright (C) 1997  Vincent Labie (sorry, no fixed email!)
   writen from Audio Excel DSP 16 software configuration routines
   Copyright (C) 1995  Riccardo Facchetti (riccardo@cdc8g5.cdc.polimi.it)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/************************************************************************************************/
/*	headers needed by this source.								*/

#ifdef	__MS32FX_EXEC__
 #include <stdio.h>
 #include <string.h>
#else
 #include "../sound_config.h"
#endif

#include <asm/io.h>

/************************************************************************************************/

#include	"ms32fxCommon.h"

MS32FXPROGHARDCFG	MS32FXProgHardCfg;
MS32FXHARDCFG		MS32FXHardCfg={	DEF_MS32FX_SBIOB,	/* sbbase		*/
					DEF_MS32FX_MSSIOB,	/* mssbase		*/
					DEF_MS32FX_MPUIOB,	/* mpubase		*/
					0,			/* PrevHardCfg		*/
					0,			/* HardCfg		*/
					INIT_NONE,		/* InitState		*/
					1,			/* HardDSPVersion	*/
					4,			/* HardDSPSubVersion	*/
					0,			/* SBIrqDmaCfg		*/
					0,			/* MSSIrqDmaCfg		*/
					{3,1}			/* Version[2]		*/
					};
/************************************************************************************************/
/*		Magic values that the DSP will eat when configuring irq/mirq/dma		*/
/*		DSP IRQ conversion array							*/

ORVALS		orValsIRQ[]=
{ {0x05,0x28}, {0x07,0x08}, {0x09,0x10}, {0x0a,0x18}, {0x0b,0x20}, {0x00,0x00} };

/************************************************************************************************/
/*		MPU-401 IRQ conversion array							*/

ORVALS		orValsMIRQ[]=
{ {0x05,0x04}, {0x07,0x44}, {0x09,0x84}, {0x0a,0xc4}, {0x00,0x00} };

/************************************************************************************************/
/*		DMA Channels conversion array							*/

ORVALS		orValsDMA[]=
{ {0x00,0x01}, {0x01,0x02}, {0x03,0x03}, {0x00,0x00} };

/************************************************************************************************/

static	char     DSPCopyright[/*CARDNAMELEN+1*/]={ 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0 };
static	char     DSPVersion[/*CARDVERLEN + 1*/]={ 0,0 };

/************************************************************************************************/
extern	void	DBGf(char * szFormat);
extern	void	DBGfs(char * szFormat,char * szText);
extern	void	DBGfi(char * szFormat,int val);
extern	void	DBGfic(char * szFormat,int val,char c);
extern	void	DBGfii(char * szFormat,int val,int val2);

extern	void	WARf(char * szFormat);
extern	void	WARfi(char * szFormat,int val);

extern	void	ERRf(char * szFormat);
extern	void	ERRfs(char * szFormat,char * szText);
extern	void	ERRfi(char * szFormat,int val);

/************************************************************************************************/
/*		Bitmapped flags of hard configuration						*/
/*		Decode macros									*/

#define IOBASE(conf)		((conf&0x0001)?0x240:0x220)
#define JOY(conf)  		(conf&0x0002)
#define MPU(conf)		(conf&0x0200)
#define MPUADDR(conf)		( 			\
				(conf&0x000C)?0x330:	\
				(conf&0x0008)?0x320:	\
				(conf&0x0004)?0x310:	\
						0x300)
#define WSS(conf)		(conf&0x8000)
#define WSSADDR(conf)		((conf&0x0010)?0xE80:0x530)
#define CDROM(conf)		(conf&0x4000)
#define CDROMTYPE(conf)		((conf&0x1800)>>3)
#define CDROMADDR(conf)		((conf&0x4000)?(((conf&0x0700)>>4)+0x300):0)

/************************************************************************************************/
/*		Encode macros									*/

#define	BLDIOBASE(conf,val)			\
{						\
	conf&= ~0x0001; 			\
	if (val==0x240)				\
		conf|=0x0001;			\
}
#define BLDJOY(conf,val)			\
{						\
	conf&=~0x0002; 				\
	if (val)				\
		conf|=0x0002;			\
}
#define BLDMPU(conf,val)			\
{						\
	conf&=~0x2000; 				\
	if (val)				\
		conf|=0x2000;			\
}
#define BLDMPUADDR(conf,val)			\
{						\
	int	tmp=val;			\
	tmp-=	0x300;				\
	tmp>>=	4;				\
	tmp&=	0x0003;				\
	tmp<<=	2;				\
	conf&=	~0x000C;			\
	conf|=	tmp;				\
}

#define BLDWSS(conf,val)			\
{						\
	conf&=~0x8000; 				\
	if (val)				\
		conf|=0x8000;			\
}
#define BLDWSSADDR(conf,val)			\
{						\
	conf&=~0x0010; 				\
	if (val==0xE80)				\
		conf|=0x0010;			\
}
#define BLDCDROM(conf,val)			\
{						\
	conf&=~0x4000; 				\
	if (val)				\
		conf|=0x4000;			\
}
#define BLDCDROMTYPE(conf,val)			\
{						\
	conf&=~0x1800; 				\
	conf|=(val&0x03)<<(3+8);		\
}
#define BLDCDROMADDR(conf,val)			\
{						\
	int	tmp=val;			\
	tmp-=	0x300;				\
	tmp>>=	4;				\
	tmp&=	0x07;				\
	conf&=~0x0700;				\
	conf|=tmp<<8;				\
}

/************************************************************************************************/
static	void	delay_10msec(void)
{	int	i; for (i=0;i<1000;i++) MS32FXudelay(10);	}

/************************************************************************************************/
static	int	WaitForDataAvail(void)
{
	int		loop;
	unsigned char	status;

	for(loop=0;loop<WAITRETRY;loop++)
		{ status=inb(MS32FXHardCfg.sbbase+DSP_DATAVAIL);
		if (status&0x80) break; }
	if (status&0x80)	return(TRUE);
	else			return(FALSE);
}

/************************************************************************************************/
static	int	LongWaitForDataAvail(void)
{
	int		loop;
	for(loop=0;loop<LONGWAITRETRY;loop++)
		if (WaitForDataAvail()==TRUE) return(TRUE);
	return(FALSE);
}

/************************************************************************************************/
static	int	ReadDSPByte(void)
{
	int		inbyte;

	DBGfi("    Read DSP Byte (0x%03X): ",MS32FXHardCfg.sbbase);
	if (WaitForDataAvail()==FALSE) { DBGf("failure.\n"); return(-1); }
	inbyte=inb(MS32FXHardCfg.sbbase+DSP_READ);
	DBGfic("read [0x%02X]/{%c}.\n",inbyte,(inbyte)?inbyte:' ');
	return(inbyte);
}

/************************************************************************************************/
static	int	CheckDSPOkay(void)
{
	int	Retry;
	for(Retry=0;Retry<RESETRETRY;Retry++) if (ReadDSPByte()==0xaa) return(TRUE);
	return(FALSE);
}

/************************************************************************************************/
static	int	ResetBoard(void)
{
	DBGf("Reset DSP:\n");
	outb(1,(MS32FXHardCfg.sbbase+DSP_RESET)); MS32FXudelay(10);
	outb(0,(MS32FXHardCfg.sbbase+DSP_RESET)); MS32FXudelay(10);
	if (CheckDSPOkay()==TRUE)	{ DBGf("success.\n"); return(TRUE); }
	else				{ DBGf("failure.\n"); return(FALSE); }
}

/************************************************************************************************/
static	int	WriteDSPByte(int cmd)
{
	unsigned char	status;
	int		loop;
	cmd&=0xff;
	DBGfii("    Write DSP Byte (0x%03X) [0x%02X]: ",MS32FXHardCfg.sbbase,cmd);
	for(loop=0;loop<WRITERETRY;loop++)
		{
		status=inb(MS32FXHardCfg.sbbase+DSP_STATUS);
		if ((status&0x80)==0)
			{ outb(cmd,MS32FXHardCfg.sbbase+DSP_COMMAND);
			DBGf("success.\n"); return(TRUE); }
		}
	DBGf("timeout.\n");
	WARfi("[MaxiSound32FX] Warning: DSP Command (0x%02X) timeout.\n",cmd);
	return(FALSE);
}

/************************************************************************************************/
	int	DisableBoard(void)
{
	DBGf("Disable board:\n");
	if (WriteDSPByte(DSP_WRITE_IRQDMA_50)==FALSE)
		DBGfi("[MaxiSound32FX] Warning: CMD 0x%02X: failed.\n",DSP_WRITE_IRQDMA_50);
	if (WriteDSPByte(0)==FALSE)
		DBGfi("[MaxiSound32FX] Warning: CMD 0x%02X: failed.\n",0);
	return(TRUE);
}

/************************************************************************************************/
static	int	WriteMSSWord(int word)
{
	int		loop;
	if (MS32FXHardCfg.mssbase==0) return(FALSE);
	word&=0xffff;
	DBGfii("    Write MSS Low  Data Byte (0x%03X) [0x%02X]\n",MS32FXHardCfg.mssbase+MSS_LDATA,
		(int)(unsigned char)word);
	for(loop=0;loop<DELAYWRITEDATA2;loop++) MS32FXudelay(1);
	outb((unsigned char)word,MS32FXHardCfg.mssbase+MSS_LDATA);
	for(loop=0;loop<DELAYWRITEDATA2;loop++) MS32FXudelay(1);
	word>>=8;
	DBGfii("    Write MSS High Data Byte (0x%03X) [0x%02X]\n",
			MS32FXHardCfg.mssbase+MSS_HDATA,word);
	outb((unsigned char)word,MS32FXHardCfg.mssbase+MSS_HDATA);
	return(TRUE);
}

/************************************************************************************************/
static	void	PrintInfo(MS32FXPROGHARDCFG* pMS32FXProgHardCfg)
{
char*	szPrintInfoCDROMType[4]={"Sony???","Panasonic","G???","IDE"};

	DBGfi("\n Base address:  0x%03X\n",	pMS32FXProgHardCfg->sbbase);
	DBGfs(" Joystick    : %s present\n",	pMS32FXProgHardCfg->joystick?"":" not");
	DBGfs(" WSS         : %s present\n",	(pMS32FXProgHardCfg->mss)?"":" not");
	DBGfi(" WSS addr    :  0x%03X\n",	pMS32FXProgHardCfg->mssbase);
	DBGfs(" MPU-401     : %s present\n",	(pMS32FXProgHardCfg->mpu)?"":" not");
	DBGfi(" MPU-401 addr:  0x%03X\n",	pMS32FXProgHardCfg->mpubase);
	DBGfs(" CDROM       : %s present\n",	(pMS32FXProgHardCfg->cdrom)?"":" not");
	DBGfs(" CDROM type  :  %s \n",		(pMS32FXProgHardCfg->cdrom)?
			szPrintInfoCDROMType[pMS32FXProgHardCfg->cdromtype]:"None");
	DBGfi(" CDROM addr  :  0x%03X\n\n",	pMS32FXProgHardCfg->cdrombase);
}

/************************************************************************************************/
static	void	DecodeHardCfg(int HardCfg,MS32FXPROGHARDCFG* pMS32FXProgHardCfg)
{
	DBGfi(" DecodeHardCfg: 0x%04X\n",HardCfg);
	pMS32FXProgHardCfg->sbbase	= IOBASE (HardCfg);
	pMS32FXProgHardCfg->joystick	= JOY(HardCfg);
	pMS32FXProgHardCfg->mss		= WSS(HardCfg);
	pMS32FXProgHardCfg->mssbase	= WSSADDR(HardCfg);
	pMS32FXProgHardCfg->mpu		= MPU(HardCfg);
	pMS32FXProgHardCfg->mpubase	= MPUADDR(HardCfg);
	pMS32FXProgHardCfg->cdrom	= CDROM(HardCfg);
	pMS32FXProgHardCfg->cdromtype	= CDROMTYPE(HardCfg);
	pMS32FXProgHardCfg->cdrombase	= CDROMADDR(HardCfg);

	DBGf(" Original sound card configuration:\n");
	PrintInfo(pMS32FXProgHardCfg);
	DBGf("success.\n");
}

/************************************************************************************************/
static	int	BuildHardCfg(MS32FXPROGHARDCFG* pMS32FXProgHardCfg)
{
	int		BuildHardCfg;
/*		Now set up the real kernel configuration.					*/
	BuildHardCfg	=0;
	BLDIOBASE(	BuildHardCfg, pMS32FXProgHardCfg->sbbase);
	BLDWSS(		BuildHardCfg, pMS32FXProgHardCfg->mss);
	BLDWSSADDR(	BuildHardCfg, pMS32FXProgHardCfg->mssbase);
	BLDMPU(		BuildHardCfg, pMS32FXProgHardCfg->mpu);
	BLDMPUADDR(	BuildHardCfg, pMS32FXProgHardCfg->mpubase);
	BLDJOY(		BuildHardCfg, pMS32FXProgHardCfg->joystick);
	BLDCDROM(	BuildHardCfg, pMS32FXProgHardCfg->cdrom);
	BLDCDROMTYPE(	BuildHardCfg, pMS32FXProgHardCfg->cdromtype);
	BLDCDROMADDR(	BuildHardCfg, pMS32FXProgHardCfg->cdrombase);
	BuildHardCfg	|=0x0040;
	BuildHardCfg	&=~0x0020;
	DBGf(" New Values:\n");
	PrintInfo(&MS32FXProgHardCfg);
	DBGfi(" BuildHardCfg: 0x%04X\n",BuildHardCfg);
	DBGf("success.\n");
	return(BuildHardCfg);
}

/************************************************************************************************/
	int	WriteHardCfg(int iWriteHardCfg)
{
	int	Ok=TRUE;
	DBGf("WriteHardCfg:\n");

	if (WriteDSPByte(DSP_WRITE_HARDCFG_6C)==FALSE)
		{ DBGfi("[MaxiSound32FX] Warning: CMD 0x%02X: failed.\n",DSP_WRITE_HARDCFG_6C);
		Ok=FALSE; }
	if (WriteDSPByte(DSP_START_W_TRANSFER_5C)==FALSE)
		{ DBGfi("[MaxiSound32FX] Warning: CMD 0x%02X: failed.\n",DSP_START_W_TRANSFER_5C);
		Ok=FALSE; }
	if (WriteDSPByte(iWriteHardCfg)==FALSE)
		{ DBGfi("[MaxiSound32FX] Warning: DATA 0x%02X: failed.\n",
			((unsigned char)iWriteHardCfg)); Ok=FALSE; }
	if (WriteDSPByte(iWriteHardCfg>>8)==FALSE)
		{ DBGfi("[MaxiSound32FX] Warning: DATA 0x%02X: failed!\n",(iWriteHardCfg>>8));
		Ok=FALSE; }
	if (WriteDSPByte(DSP_END_W_TRANSFER_C5)==FALSE)
		{ DBGfi("[MaxiSound32FX] Warning: CMD 0x%02X: failed!\n",DSP_END_W_TRANSFER_C5);
		Ok=FALSE; }
	if (Ok) DBGf("success.\n");
	return(TRUE);
}

/************************************************************************************************/
static	int	ReadHardCfg(void)
{
	int			H;
	int			iReadHardCfg;
	DBGf("ReadHardCfg:\n");

	if (WriteDSPByte(DSP_READ_HCFG_58)==FALSE)
		{ ERRfi("[MaxiSound32FX] Error: CMD 0x%02X: failed!\n",DSP_READ_HCFG_58);
		return(-1); }
	if ((iReadHardCfg=ReadDSPByte()) == -1)
		{ ERRfi("[MaxiSound32FX] Error: ReadDSPByte after CMD 0x%02X: failed\n",
				DSP_READ_HCFG_58); return(-1); }
	if ((H=ReadDSPByte())==-1)
		{ ERRfi("[MaxiSound32FX] Error: ReadDSPByte after CMD 0x%02X: failed\n",
				DSP_READ_HCFG_58); return(-1); }
	iReadHardCfg+=H<<8;
	if (ReadDSPByte()==-1)
		{ ERRfi("[MaxiSound32FX] Error: ReadDSPByte after CMD 0x%02X: failed\n",
				DSP_READ_HCFG_58); return(-1); }
	DBGf("success.\n");
	return(iReadHardCfg);
}

/************************************************************************************************/
static	int	WriteSoftCfg(void)
{
	DBGfi("[MaxiSound32FX] Info: soft config: 0x%02X.\n",MS32FXHardCfg.SBIrqDmaCfg);
	DBGfi("                  IRQ     : %i.\n",MS32FXProgHardCfg.irq);
	DBGfi("                  MPU IRQ : %i.\n",MS32FXProgHardCfg.mpuirq);
	DBGfi("                  DMA     : %i.\n",MS32FXProgHardCfg.dma);
	if (WriteDSPByte(DSP_WRITE_IRQDMA_50)==FALSE)
		DBGfi("[MaxiSound32FX] Warning: CMD 0x%02X: failed.\n",DSP_WRITE_IRQDMA_50);
	if (WriteDSPByte(MS32FXHardCfg.SBIrqDmaCfg)==FALSE)
		DBGf("[MaxiSound32FX] Warning: Initialization of (M)IRQ and DMA: failed.\n");
	return(TRUE);
}


/************************************************************************************************/
static	int	SetMSSMode(void)
{
	DBGf("SetMSSMode:\n");
	if (WriteDSPByte(DSP_INIT_MSS_MODE_8C)==FALSE)
		DBGfi("[MaxiSound32FX] Warning: SetMSSMode [0x%02X]: failed.\n",
			DSP_INIT_MSS_MODE_8C);
	return(TRUE);
}

/************************************************************************************************/
static	int	InitMSS(void)
{
	if (MS32FXProgHardCfg.mssbase==0) return(FALSE);
	DBGf("InitMSS:\n");
	delay_10msec();
	if (WriteDSPByte(DSP_INIT_MSS_MODE_8C)==FALSE)
		{ ERRfi("[MaxiSound32FX] Error: InitMSS [0x%02X]: failed!\n",
				DSP_INIT_MSS_MODE_8C); return FALSE; }
	delay_10msec();

	if (WriteSoftCfg()==FALSE) return(FALSE);
	outb(MS32FXHardCfg.MSSIrqDmaCfg,MS32FXHardCfg.mssbase);
	DBGf("success.\n");
	return(TRUE);
}

/************************************************************************************************/
static	int	GetDSPHardSubVersion(void)
{
	unsigned char	lowbyte,highbyte;

	if (MS32FXProgHardCfg.mssbase==0) goto end;
	WriteMSSWord(0x000C);
	lowbyte=	inb(MS32FXHardCfg.mssbase+MSS_HDATA);
	DBGfi("[MaxiSound32FX] Info: read :%02X\n",lowbyte);
	WriteMSSWord(0xFF0C);
	highbyte=	inb(MS32FXHardCfg.mssbase+MSS_HDATA);
	DBGfi("[MaxiSound32FX] Info: read :%02X\n",highbyte);
	WriteMSSWord(0xCA0C);
	if ((lowbyte&0x80)==0)	{ MS32FXHardCfg.HardDSPSubVersion=8; goto end; }
	if (highbyte&0x30)	{ MS32FXHardCfg.HardDSPSubVersion=4; goto end; }
	WriteMSSWord(0x0019);
	lowbyte	=	inb(MS32FXHardCfg.mssbase+MSS_HDATA);
	DBGfi("[MaxiSound32FX] Info: read [0x%02X]\n",lowbyte);
	lowbyte&=	0xE0;
	DBGfi("[MaxiSound32FX] Info:   => [0x%02X]\n",lowbyte);
	if (lowbyte==0x80)	{ MS32FXHardCfg.HardDSPSubVersion=1; goto end; }
	if (lowbyte==0xA0)	{ MS32FXHardCfg.HardDSPSubVersion=2; goto end; }
end:
	DBGfi("[MaxiSound32FX] Info: GetDSPHardSubVersion :%i\n",MS32FXHardCfg.HardDSPSubVersion);
	return(TRUE);
}

/************************************************************************************************/
static	int	GetDSPHardVersion(void)
{
	if (ResetBoard()==FALSE)
		DBGf("[MaxiSound32FX] Warning: Resetboard failed.\n");
	if (WriteDSPByte(DSP_START_W_TRANSFER_5C)==FALSE)
		DBGfi("[MaxiSound32FX] Warning: CMD 0x%02X: failed.\n",DSP_START_W_TRANSFER_5C);
	if (ReadDSPByte()==-1)
		MS32FXHardCfg.HardDSPVersion=2;
	else	MS32FXHardCfg.HardDSPVersion=3;
	DBGfi("[MaxiSound32FX] Info: GetDSPHardVersion :%i\n",MS32FXHardCfg.HardDSPVersion);
	if (ResetBoard()==FALSE)
		DBGf("[MaxiSound32FX] Warning: Resetboard failed.\n");
	return(TRUE);
}

/************************************************************************************************/
	int	WriteHardIRQDMA(void)
{
	if (WriteDSPByte(DSP_RESET_TO_SB_88)==FALSE)
		WARfi("[MaxiSound32FX] Warning: CMD 0x%02X: failed.\n",DSP_RESET_TO_SB_88);
	if (LongWaitForDataAvail()==FALSE)
		WARfi("[MaxiSound32FX] Warning: WaitForDataAvail after CMD 0x%02X: failed.\n",
			DSP_RESET_TO_SB_88);
	if (ReadDSPByte()==-1)
		WARfi("[MaxiSound32FX] Warning: ReadDSPByte after CMD 0x%02X: failed.\n",
			DSP_RESET_TO_SB_88);
	if (WriteSoftCfg()==FALSE)
		WARf("[MaxiSound32FX] Warning: WriteSoftConfig Failed.\n");
	return(TRUE);
}

/************************************************************************************************/
static	int	SetDSPVersion(void)
{
	if (MS32FXHardCfg.HardDSPVersion==3)
		{
		int		val;
		switch (MS32FXHardCfg.HardDSPSubVersion)
			{
			case 4:	val=6; break;
			case 1:	val=2; break;
			case 2:	val=2; break;
			case 8:
			default:val=1; break;
			}
		if (WriteDSPByte(COMMAND_60)==FALSE)
			WARfi("[MaxiSound32FX] Warning: CMD 0x%02X: failed.\n",COMMAND_60);
		if (WriteDSPByte(val)==FALSE)
			WARfi("[MaxiSound32FX] Warning: CMD data 0x%02X: failed.\n",val);
		}
	if (ResetBoard()==FALSE)
		DBGf("[MaxiSound32FX] Warning: ResetBoard failed.\n");
	return(TRUE);
}

/************************************************************************************************/
static	int	GetDSPVersion(void)
{
	int		len=0;
	int		status;

	DBGf("Get DSP Version:\n");
	if (WriteDSPByte(GET_DSP_VERSION_E1)==FALSE)
		{ ERRfi("[MaxiSound32FX] Error: CMD 0x%02X: failed!\n",GET_DSP_VERSION_E1);
		return(FALSE); }
	for(len=0;len<CARDVERLEN;len++)
		{ if ((status=ReadDSPByte())==-1) { DBGf("failed.\n"); return(FALSE); }
		MS32FXHardCfg.Version[len]=status; }
	sprintf(DSPVersion,"%d.%d",MS32FXHardCfg.Version[1],MS32FXHardCfg.Version[0]);
	DBGf("success.\n");
	return(TRUE);
}

/************************************************************************************************/
static	int	GetDSPCopyright(void)
{
	int		len=0;
	int		status;

	DBGf("Get DSP Copyright:\n");
	if (WriteDSPByte(GET_DSP_COPYRIGHT_E3)==FALSE)
		{ ERRfi("[MaxiSound32FX] Error: CMD 0x%02X: failed!\n",GET_DSP_COPYRIGHT_E3);
		return FALSE; }

	for(len=0;len<CARDNAMELEN;len++)
		{
		if ((status=ReadDSPByte())==-1)
			{
			if (len)	break;
			else		{ DBGf("failed.\n"); return(FALSE); }
			}
		DSPCopyright[len]=status;
		}
	DBGf("success.\n");
	return(TRUE);
}

/************************************************************************************************/
static	void	InitializeHardParams(void)
{
	int			i;

	MS32FXHardCfg.sbbase		=0x220;
	MS32FXHardCfg.HardDSPVersion	=1;
	MS32FXHardCfg.HardDSPSubVersion	=4;
	memset(DSPCopyright,0,CARDNAMELEN+1);
	memset(DSPVersion,0,CARDVERLEN+1);

	for(i=0;orValsIRQ[i].or;i++)
		if (orValsIRQ[i].val==MS32FXProgHardCfg.irq)
			{ MS32FXHardCfg.SBIrqDmaCfg|=orValsIRQ[i].or;
			MS32FXHardCfg.MSSIrqDmaCfg|=orValsIRQ[i].or; }

	for(i=0;orValsMIRQ[i].or;i++)
		if (orValsMIRQ[i].val==MS32FXProgHardCfg.mpuirq)
			MS32FXHardCfg.SBIrqDmaCfg|=orValsMIRQ[i].or;

	for(i= 0; orValsDMA[i].or;i++)
		if (orValsDMA[i].val==MS32FXProgHardCfg.dma)
			{ MS32FXHardCfg.SBIrqDmaCfg|=orValsDMA[i].or;
			MS32FXHardCfg.MSSIrqDmaCfg|=orValsDMA[i].or; }
}

/************************************************************************************************/
static	int	ResetBoardFirst(void)
{
	int		Retry;
	int		Ok;
	for(Retry=0;Retry<3;Retry++)
		{
		if (ResetBoard()==FALSE)
			{ WARfi("[MaxiSound32FX] Warning: ResetBoard %i: failed.\n",Retry);
			Ok=FALSE;continue; }
		else	{ WARfi("[MaxiSound32FX] Warning: ResetBoard %i: success.\n",Retry); }
		if (GetDSPCopyright()==FALSE)
			{ WARfi("[MaxiSound32FX] Warning: GetDSPCopyright %i: failed.\n",Retry);
			Ok=FALSE; continue; }
		else	{ WARfi("[MaxiSound32FX] Warning: GetDSPCopyright %i: success.\n",Retry);
			Ok=TRUE; }
		if (Ok) break;
		}
	if (Ok)	if (strcmp("SC-6000",DSPCopyright))
			{ ERRf("[MaxiSound32FX] Fatal: non SC-6000 audio card!\n");
			return(FALSE); }
	return(Ok);
}

/************************************************************************************************/
	int	InitMS32FX(void)
{
	MS32FXPROGHARDCFG	PrevMS32FXProgHardCfg;
	DBGf("[[MaxiSound32FX]] call InitializeHardParams\n");
	InitializeHardParams();

	DBGf("[[MaxiSound32FX]] call ResetBoardFirst\n");
	if (ResetBoardFirst()==FALSE)
		{ ERRf("[MaxiSound32FX] Fatal: ResetBoard failed!\n"); return(FALSE); }
	else	{ DBGf("[MaxiSound32FX] Info: ResetBoard success.\n"); }

	DBGf("[[MaxiSound32FX]] call GetDSPVersion\n");
	if (GetDSPVersion()==FALSE)
		{ ERRf("[MaxiSound32FX] Fatal: G etDSPVersion: failed!\n"); return(FALSE); }
	DBGf("[[MaxiSound32FX]] call ReadHardCfg\n");
	if ((MS32FXHardCfg.PrevHardCfg=ReadHardCfg())==-1)
		{ ERRf("[MaxiSound32FX] Fatal: ReadHardCfg: failed!\n"); return(FALSE); }

	DBGf("[[MaxiSound32FX]] call DecodeHardCfg\n");
	DecodeHardCfg(MS32FXHardCfg.PrevHardCfg,&PrevMS32FXProgHardCfg);
	DBGf("[[MaxiSound32FX]] call BuidHardCfg\n");
	MS32FXHardCfg.HardCfg=BuildHardCfg(&MS32FXProgHardCfg);
	DBGf("[[MaxiSound32FX]] call WriteHardCfg\n");
	if (WriteHardCfg(MS32FXHardCfg.HardCfg)==FALSE)
		{ ERRf("[MaxiSound32FX] Fatal: WriteHardCfg: failed!\n"); return(FALSE); }

	MS32FXHardCfg.sbbase	=MS32FXProgHardCfg.sbbase;
	MS32FXHardCfg.mssbase	=MS32FXProgHardCfg.mssbase;
	MS32FXHardCfg.mpubase	=MS32FXProgHardCfg.mpubase;

	DBGf("[[MaxiSound32FX]] call WriteHardIRQDMA\n");
	if (WriteHardIRQDMA()==FALSE)
		{ ERRf("[MaxiSound32FX] Warning: WriteHardIRQDMA: failed!\n"); return(FALSE); }
	DBGf("[[MaxiSound32FX]] call GetDSPHardVersion\n");
	if (GetDSPHardVersion()==FALSE)
		WARf("[MaxiSound32FX] Warning: GetDSPHardVersion Failed.");
	DBGf("[[MaxiSound32FX]] call SetMSSMode\n");
	if (SetMSSMode()==FALSE)
		WARf("[MaxiSound32FX] Warning: SetMSSMode Failed.");
	DBGf("[[MaxiSound32FX]] call GetDSPHardSubVersion\n");
	if (GetDSPHardSubVersion()==FALSE)
		WARf("[MaxiSound32FX] Warning: GetDSPHardSubVersion Failed.");

	DBGfii("Maxisound32FX hard version %i.%i\n",
		MS32FXHardCfg.HardDSPVersion,MS32FXHardCfg.HardDSPSubVersion);

	DBGf("[[MaxiSound32FX]] call WriteHardIRQDMA\n");
	if (WriteHardIRQDMA()==FALSE)
		WARf("[MaxiSound32FX] Warning: WriteHardIRQDMA: failed.\n");
	DBGf("[[MaxiSound32FX]] call SetDSPVersion\n");
	if (SetDSPVersion()==FALSE)
		WARf("[MaxiSound32FX] Warning: SetDSPVersion: failed.\n");
	DBGf("[[MaxiSound32FX]] call SetMSSMode\n");
	if (SetMSSMode()==FALSE)
		WARf("[MaxiSound32FX] Warning: SetMSSMode: failed.\n");
	DBGf("[[MaxiSound32FX]] call WriteHardIRQDMA\n");
	if (WriteHardIRQDMA()==FALSE)
		WARf("[MaxiSound32FX] Warning: WriteHardIRQDMA Failed.");
	if (MS32FXHardCfg.mssbase!=0)
		if (MS32FXHardCfg.InitState&INIT_MSS)
			if (InitMSS()==FALSE)
				{ ERRf("[MaxiSound32FX] Fatal: Can not initialize "
				       "Microsoft Sound System mode.\n"); return FALSE; }

	ERRfs("Maxisound32FX init v%s ",VERSION);
	ERRfs("(%s ",DSPCopyright);
	ERRfs("%s) [",DSPVersion);
	if (MS32FXHardCfg.InitState&INIT_MPU401)
		{
		ERRf("MPU401");
		if ((MS32FXHardCfg.InitState&INIT_MSS)||(MS32FXHardCfg.InitState&INIT_SBPRO))
			ERRf(" ");
		}
	if (MS32FXHardCfg.InitState&INIT_SBPRO)
		{ ERRf("SBPro"); if (MS32FXHardCfg.InitState&INIT_MSS) ERRf(" "); }
	if (MS32FXHardCfg.InitState&INIT_MSS) ERRf("MSS");

	ERRf("]\n");

	delay_10msec();
	return(TRUE);
}

/************************************************************************************************/

