#include "nextp.h"
#include <stdlib.h>

#define X 720
#define Y 344
#define STEPS 1000
#define SR    (1.0/STEPS)
#define FAST  40000

void nextp(double *a,double *b) {
	static int s=0,t=0;
	static double fx, fy;
	static double dx=0, dy=0;
	static double ddx=0, ddy=0;
	double nx, ny, gx, gy, tt;

	if(s==0||s<=t) { 
		fx=*a; fy=*b;
TRY_AGAIN:
		nx=(drand48()*X+fx)/2;
		ny=(drand48()*Y+fy)/2;
		gx=nx-fx; gy=ny-fy;
		dx=dx+t*SR*ddx;
		dy=dy+t*SR*ddy;
		ddx=2*(gx-dx);
		ddy=2*(gy-dy);
		s=drand48()*STEPS;t=0;
		if((dx+s*SR*ddx)*(dx+s*SR*ddx)+(dy+s*SR*ddy)+(dy+s*SR*ddy)>FAST) goto TRY_AGAIN;
		/* printf("%d %d %8.3f %8.3f %8.3f %8.3f\n",s,t,dx,dy,ddx,ddy); */
	}
	/* printf("%8.3f %8.3f %8.3f %8.3f %8.3f %8.3f\n",*a,*b,dx,dy,ddx,ddy); */
	t++; /* *a+=dx*.01; *b+=dy*.01; */
	tt=t*SR;
	*a=fx+tt*(dx+tt*(ddx/2));
	*b=fy+tt*(dy+tt*(ddy/2));
	/* dx+=ddx*.01; dy+=ddy*.01; */
}
