/*
 * mda.c
 *
 * Kernel module to drive MDA nonitor
 *
 * v0.7 1995 Patrick J Caulfield
 *
 * Revision History:
 *
 * v0.1   3-Jun-1995  PJC  First implementation as a kernel module
 * v0.2   4-Jun-1995  PJC  Allowed multiple opens to be active
 * v0.3   4-Jun-1995  PJC  Added hardware scrolling support
 * v0.4   6-Jun-1995  PJC  Fixed odd scrolling bug.
 * v0.5   9-Jul-1995  PJC  Added DEL/BS support
 * v0.6  18-Jul-1995  PJC  Now include autoconf.h to get CONFIG_MODVERSIONS
 *                         Started vt100 support. 
 * v0.7  21-Jul-1995  PJC  Added card detection and reverse video in place of
 *                         flashing.
 * v0.8  15-Jan-1996  JBE  Integrated support for Hercules graphics.
 *
 ******************************************************************************

    (c) 1995 P.J. Caulfield     patrick@pandh.demon.co.uk
                                pcaulfield@cix.compulink.co.uk
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 ******************************************************************************
 */

/* Linux module includes */
#include <linux/errno.h>
#include <linux/kernel.h>
#include <linux/major.h>
#include <linux/sched.h>
#include <linux/ioport.h>
#include <linux/fcntl.h>
#include <linux/delay.h>
#include <asm/io.h>
#include "hercules.h"


/* Function prototypes */
static void   clear_screen(void);
static void   write_char(char);
static void   set_cursor(unsigned short);
static int    scroll_screen(void);
void   clear_blink_flag(void);
static inline void set_origin(unsigned short);


/* Globals */
static unsigned short offset = 0; /* Current offset into video memory */
static unsigned short base   = 0; /* Current location of top of display */

/* Include the ANSI/vt100 emulation module */
#include "vt100.c"


/*
 * Clearing the blink flag in the control register makes the BLINK
 * attribute show reverse instead.
 * I *much* prefer this. If you don't then define DO_BLINK in mda.h
 */
void clear_blink_flag()
{
    outb(0x09, video_mode_reg);
}

/*
 * No clues
 */
static void clear_screen()
{
    int i;
    char* videomem = (char*)VIDEOMEM_START;

    base = 0;    
    for (i=0; i<VIDEOSCREEN_SIZE; i++,i++)
    {
	videomem[i] = ' ';
	videomem[i+1] = ATTR_NORMAL;
    }
    offset = 0;
    set_cursor(0);
    set_origin(0);
}

/*
 * Write a single character to the screen.
 */
static void text_write_char(char outchar)
{
    vt100_write(outchar);
}

/*
 * Scroll up by one line
 */
static int scroll_screen()
{
    int i;
    char* videomem = (char*)VIDEOMEM_START;

    /*offset = VIDEOSCREEN_SIZE - VIDEO_LINELENGTH; /* Stay on the bottom line */
    offset -= VIDEO_LINELENGTH;
    base  += VIDEO_LINELENGTH;

/* Reached the end of video memory? -- go back to the beginning and start again */	
    if (1||base+VIDEOSCREEN_SIZE+VIDEOMEM_START >= VIDEOMEM_END)
    {
	memcpy((char*)(videomem), (char*)(videomem+base), VIDEOSCREEN_SIZE-VIDEO_LINELENGTH);
	base = 0;
    }
    
    /* Clear the bottom line */
    for (i=VIDEOSCREEN_SIZE-VIDEO_LINELENGTH; i<VIDEOSCREEN_SIZE; i++,i++)
    {
	videomem[base+i] = ' ';
	videomem[base+i+1] = ATTR_NORMAL;
    }
    
#ifdef DEBUG
    printk("mda: video base address is: %d\n", base);
#endif
    set_origin(base);

    return offset;
}

/*
 * Move the offset into video memory -- Hardware scrolling
 */
static inline void set_origin(unsigned short offset)
{

    base = offset;
    cli();

    outb(13, video_port_reg);
    outb(offset >> 1, video_port_val);
    outb(12, video_port_reg);
    outb(offset >> 9, video_port_val);
}


/*
 * Position the cursor
 */
void set_cursor(unsigned short pos)
{
    int video_mem_base = VIDEOMEM_START;

    cli();
    outb(14, video_port_reg);
    outb(0xff&((pos-video_mem_base+base)>>9), video_port_val); 
    outb(15, video_port_reg);
    outb(0xff&((pos-video_mem_base+base)>>1), video_port_val);
}

/*------------------------- Basic file operations ---------------------------*/

/*
 * Write a string to the screen
 */
int text_write(struct inode * inode, struct file * file, const char * buf, int count)
{
    int        i;
    const char *temp = buf;
    char       c;
    
    for (i=0; i<count; i++)
    {
	c = get_fs_byte(temp+i);
	text_write_char(c);
    }
    return count;
}

/*
 * Open -- no sharing check otherwise we can't redirect
 * both stderr and stdout to the mono monitor.
 */
int text_open(struct inode * inode, struct file * file)
{
    return 0;
}

/*
 * Close
 */
void text_release(struct inode * inode, struct file * file)
{
}
