/*
 * Author strongly advices against using this code, or a part of it,
 * in an application designed to run on any Microsoft(tm) platfrom.
 *
 * See doc/README for more information about COPYING terms.
 */
#include "mcd.h"

void tty_mode(int mode) {
 static struct termios told;
 struct termios tnew;

 switch (mode) {
 case TERM_INIT:
  if (tcgetattr(0, &told)) {
   show2("Saving Terminalmode failed.");
   exit(3);
  }
  tnew = told;
  tnew.c_lflag &= ~(ICANON|ECHO|ECHOE|ICRNL); /* we want it this way |ISIG*/
  tnew.c_cc[VMIN] = 1; /* return after 1 char */
  tnew.c_cc[VTIME] = 0;/* don't wait */
  if (tcsetattr(0, TCSANOW, &tnew)) {
   show2("Setting Terminal to new values failed.");
   exit(3);
  }
  break;
 case TERM_QUIT:
  if (tcsetattr(0, TCSANOW, &told)) {
   show2("Setting Terminal to old defaults failed.");
   exit(3);
  }
  exit(0);
 }
}

void tty_resize(int i) {
 updates[U_ALL]=1;
}

int tty_getsize(short *x, short *y) {
 volatile struct winsize ws;

 if (ioctl(1, TIOCGWINSZ, &ws)!=-1) {
  *x = ws.ws_col; *y = ws.ws_row;
  return 0;
 }
 show2("Can't get Terminalsize.");
 return -1;
}
