/*
 * Author strongly advices against using this code, or a part of it,
 * in an application designed to run on any Microsoft(tm) platfrom.
 *
 * See doc/README for more information about COPYING terms.
 */
#include "mcd.h"
short maxx,maxy;  /* screenmaxima */

static void draw_hline(int i, char *ch); /* draw an hline */
static void draw_box(int x1, int y1, int x2, int y2); /* draw a box */
static void draw_method(char *msg);
static void draw_initscr(void);
static void draw_tracks(struct mcd *cd);

static void draw_hline(int i, char *ch) {
 if (i<0) return;
 while (i!=1) {
  show1(ch);--i;
 }
 return;
}

static void draw_box(int x1, int y1, int x2, int y2) {
 register int i;
 gotoxy(x1,y1);show1(AC_TL);draw_hline(x2-x1,AC_HL);show1(AC_TR);
 for (i=1;i!=y2-1;++i) {
  gotoxy(x1,y1+i);show1(AC_VL);
  gotoxy(x2,y1+i);show1(AC_VL);
 }
 gotoxy(x1,y2);show1(AC_BL);draw_hline(x2-x1,AC_HL);show1(AC_BR);
 return;
}

static void draw_method(char *msg) {
 gotoxy(11,5);
 _printf(C_STATUS "%s" C_NORMAL, msg);
 return;
}

static void draw_initscr(void) {
 register int i;
 show1(C_NORMAL T_CLEAR C_BOX);
 draw_box(1,1,maxx,maxy); /* the bigbox */
 gotoxyw(1,9, AC_ML);
 draw_hline(maxx-1,AC_HL);
 show1(AC_MR); /* border */

 if (cddb) { /* vline */
  gotoxy(34,1);show1(AC_MB);
  for (i=2;i<6;i++) {
   gotoxy(34,i);
   show1(AC_VL);
  }
  gotoxy(34,i);show1(AC_BL);
  draw_hline(maxx-34,AC_HL);
  show1(AC_MR);
 }
 show1(C_HEADLINE);
 gotoxyw(3,2, "mcd version " MCD_VERSION);
 if (cddb) gotoxyw(36,2,"freedb info");
 gotoxyw(3,10,"tracklist");
 show1(C_DESCRIPT);
 gotoxyw(3,4, "Status:");
 gotoxyw(3,5, "Method:");
 gotoxyw(3,6, "Volume:");
 gotoxyw(3,7, "Track:");
 gotoxyw(3,8, "CD:");
 if (cddb) {
  gotoxyw(36,4,"Source:");
  gotoxyw(36,5,"DiscID:");
 }
 return;
}

/* this function looks strange since cddb =:) */
static void draw_tracks(struct mcd *cd) {
 register int i,m; /* title/modifier/realtitle */
 int y=0,x=0; /* x,y==diffs to real */

 for (i=1;(i<=cd->title[1] && i<=MCD_CDAUDIO_MAX); i++) {
  m=((i-(pluskey+1)*10)<0 && (i-(pluskey+1)*10)>-11); /* is shortcut? */
  if (i%(maxy-10)==0) {y=-i;x+=15;} /* bottom reached, horiz. isn't checked! */
  gotoxy(3+x,10+i+y);
  if (m&&(i==cd->title[0])) _printf(C_STATUS "%02d" C_NORMAL, i); /* current */
  else if (m||(i==cd->title[0])) _printf(T_BOLD "%02d" C_NORMAL, i); /* current */
  else _printf("%02d",i); /* nothing special */
  if (i==cd->title[0]) show1(T_BOLD); /* current */
  _printf("%c - %02d:%02d\n",
   cd->t[i].audio?'d':'a',
   cd->t[i].min,
   cd->t[i].sec);
  if (i==cd->title[0]) show1(C_NORMAL); /* current */
 }

 if (cddb) { /* if we have cddb */
  gotoxyw(44,4,C_STATUS);
  if (cddb==CDDB_LOCAL) show1("local file");
  else _printf("remote, via %s:%s",ip,port); /* can only be REMOTE */
  gotoxy(44,5);_printf("%08x",cd_discid(&cd[0]));

  /* titelinfo */
  gotoxy(18,8); _printf(C_NORMAL T_BOLD "%s",cd->t[0].name); /* always */
  if (x) {
   /* we display only current */
   gotoxy(18,7); _printf("%s" C_NORMAL, cd->t[cd->title[0]].name);
   for (i=strlen(cd->t[cd->title[0]].name)+19;i<=maxx;i++)
    write(1," ",1);  /* clear old titleinfos */
  } else {
   /* we display all title */
   gotoxy(16,9);show1(C_BOX AC_MB);
   for (i=10;i<maxy;i++) gotoxyw(16,i,AC_VL);
   gotoxy(16,maxy);show1(AC_MT C_NORMAL);
   for (i=1;i<=cd->title[1];i++) {
    gotoxy(18,10+i);
    if (i==cd->title[0]) show1(T_BOLD);
    _printf("%s",cd->t[i].name);
    if (i==cd->title[0]) show1(C_NORMAL);
   }
  } /* all title */
 } /* cddb */
 show1(C_STATUS); /* trackmodifier */
 gotoxy(13,10);
 _printf("(%d)", pluskey);
 return;
}

void draw_status(char *msg, short again) {
 gotoxy(11,4);
 _printf(C_STATUS "%-23s" C_NORMAL, msg);
 if (again) {
  updates[U_STATUS]=1;
  sleep(again);
 }
 return;
}

void draw_updatescr(struct mcd *cd) {
 if (cd_readsubchannel(cd)<0) {
  draw_status("no disc (use e/c)",0);
  return;
 }

 show1(C_NORMAL);
 if (updates[U_ALL]) {
  signal(SIGWINCH,tty_resize);
  show1(C_NORMAL T_CLEAR);
  tty_getsize(&maxx,&maxy);
  if (maxx<78 || maxy<13) {
   show2(T_NORMAL T_CLEAR "Sorry, you need at least a termsize of 78x13.\n");
   tty_mode(TERM_QUIT);
  }
  cddb=cd_readtracks(&cd[0]);
  draw_initscr();
  updates[U_TRACKS]=updates[U_STATUS]=updates[U_METHOD]=updates[U_VOLUME]=1;
  updates[U_ALL]=0;
 }

 if (updates[U_STATUS]) {
  draw_status(
  (cd->status==CDROM_AUDIO_NO_STATUS) ? "no status":"" &&
  (cd->status==CDROM_AUDIO_ERROR    ) ? "error    ":"" &&
  (cd->status==CDROM_AUDIO_COMPLETED) ? "completed":"" &&
  (cd->status==CDROM_AUDIO_PAUSED   ) ? "paused   ":"" &&
  (cd->status==CDROM_AUDIO_PLAY     ) ? "playing  ":"" &&
  (cd->status==CDROM_AUDIO_INVALID  ) ? "invalid  ":"",0);
  updates[U_STATUS]=0;
 }

 if (updates[U_METHOD]) {
  draw_method(
  (cd->method==M_PLAY_CD)    ? "play cd     ":"" &&
  (cd->method==M_REPEAT_CD)  ? "repeat cd   ":"" &&
  (cd->method==M_REPEAT_TRK) ? "repeat track":"" &&
  (cd->method==M_INTRO)      ? "intro       ":"");
  updates[U_METHOD]=0;
 }

 if (updates[U_TRACKS]) {
  draw_tracks(&cd[0]);
  updates[U_TRACKS]=0;
 }

 show1(C_STATUS);
 if (updates[U_VOLUME]==1) {
  gotoxy(11,6);
  _printf("%d%%  ", (int)(cd->vol.channel0/2.55));
  updates[U_VOLUME]=0;
 }

 /* always */
 gotoxy(11,7);
 _printf("%02d:%02d",
  cd->cds.cdsc_reladdr.msf.minute,
  cd->cds.cdsc_reladdr.msf.second);
 gotoxy(11,8);
 _printf("%02d:%02d",
  cd->cds.cdsc_absaddr.msf.minute,
  cd->cds.cdsc_absaddr.msf.second);
  show1(T_HOME);
 return;
}
