
/*
 *    Copyright (C) 1996  Burkhard Kohl
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * 	$Id: hexbin.c++,v 0.6 1996/12/07 20:30:04 buk Exp buk $
 *
 *	$Log: hexbin.c++,v $
 *	Revision 0.6  1996/12/07 20:30:04  buk
 *	Changed writeHexFile to output hexRecs only when aktSize > 0.
 *
 *	Revision 0.5  1996/12/07 19:42:30  buk
 *	Changed readHexFile to accept an istream&.
 *	Renamed crc_ to chk_ because it was never an crc_.
 *
 *	Revision 0.4  1996/12/05 16:48:27  buk
 *	Made hexRec output skip over multiple \000s.
 *
 *	Revision 0.3  1996/12/04 18:54:56  buk
 *	Added ostream& operator<<(..) and made writeHexFile to support
 *	writing to an ostream.
 *
 *	Revision 0.2  1996/12/02 19:47:42  buk
 *	Usage of const constructs corrected.
 *	Code for class writeHexFile.
 *	Allowed for MSDog style line breaks.
 *
 *	Revision 0.1  1996/11/30 15:15:33  buk
 *	Initial Revision.
 *
 *
 */

static char rcsid[] = "$Id: hexbin.c++,v 0.6 1996/12/07 20:30:04 buk Exp buk $";

#include "hexbin.h"
#include <stdio.h>

const ushort hexFile::maxLineLen = MAXHEXRECSIZE +2;

hexByte::hexByte()
	: hexByte1_('0'), hexByte2_('0')
	, valid_(FALSE)
	, binvalue_(0)
	{ }

hexByte::hexByte(const byte aktvalue)
	: hexByte1_(digit2hex(aktvalue / 0x10))
	, hexByte2_(digit2hex(aktvalue % 0x10))
	, valid_(TRUE)
	, binvalue_(aktvalue)
	{ }

hexByte::hexByte(const char a, const char b) {
	if (isxdigit(b) && isxdigit(a))
	{
		valid_ = TRUE;
		hexByte1_ = a; hexByte2_ = b;
		binvalue_   = toBin_();
	} else {
		valid_ = FALSE;
	}
}

hexByte::hexByte(const char* pAktLine) {
	hexByte tmp = hexByte(*pAktLine, *(pAktLine+1));
	hexByte1_ = tmp.hexByte1_;
	hexByte2_ = tmp.hexByte2_;
	valid_    = tmp.valid_;
	binvalue_ = tmp.binvalue_;
	// printf("%c,%c,%u\n", tmp.hexByte1_, tmp.hexByte2_, tmp.binvalue_);
}

byte hexByte::hexToBin(const char source) const
{
	byte result = 0;
	if (isdigit(source))
	{
		result = (source - '0');
	} else {
		if (islower(source))
		{
			result = source - 87;
		} else {
			result = source - 55;
		}
	}
	return result;
}

/*
hexByte hexByte::operator=(const hexByte& source)
{
	hexByte_[0] = source.hexByte_[0];
	hexByte_[1] = source.hexByte_[1];
	valid_      = source.valid_;
	binvalue_   = source.binvalue_;
	return *this;

}
 */

ostream& operator<<(ostream& o, const hexByte& hB) {
	o << hB.hexByte1_ << hB.hexByte2_;
	return o;
}



hexWord::hexWord()
{
	hexWord(0, 0);
}

hexWord::hexWord(const byte a, const byte b)
{
	hexWord1_ = hexByte(a);
	hexWord2_ = hexByte(b);
	valid_    = (bool)(hexWord1_.valid() && hexWord2_.valid());
	binvalue_ = toBin_();
}

hexWord::hexWord(const word aktvalue)
{
	hexWord tmp = hexWord(aktvalue / 0x100, aktvalue % 0x100);
	hexWord1_ = tmp.hexWord1_;
	hexWord2_ = tmp.hexWord2_;
	valid_    = tmp.valid_;
	binvalue_ = tmp.binvalue_;
}

hexWord::hexWord(const char a, const char b, const char c, const char d)
{
	hexWord tmp = hexWord(hexByte(a,b), hexByte(c,d));
	hexWord1_ = tmp.hexWord1_;
	hexWord2_ = tmp.hexWord2_;
	valid_    = tmp.valid_;
	binvalue_ = tmp.binvalue_;
}

hexWord::hexWord(const char* pAktLine)
{
	hexWord tmp = hexWord(*pAktLine, *(pAktLine+1), *(pAktLine+2), *(pAktLine+3));
	hexWord1_ = tmp.hexWord1_;
	hexWord2_ = tmp.hexWord2_;
	valid_    = tmp.valid_;
	binvalue_ = tmp.binvalue_;
}

hexWord::hexWord(const hexByte lsb)
{
	hexWord tmp = hexWord(hexByte(), hexByte(lsb));
	hexWord1_ = tmp.hexWord1_;
	hexWord2_ = tmp.hexWord2_;
	valid_    = tmp.valid_;
	binvalue_ = tmp.binvalue_;
}

hexWord::hexWord(const hexByte msb, const hexByte lsb)
{
	hexWord1_ = msb;
	hexWord2_ = lsb;
	valid_    = (bool)(hexWord1_.valid() && hexWord2_.valid());
	binvalue_ = hexWord1_.binvalue()*0x100 + hexWord2_.binvalue();
}

ostream& operator<<(ostream& o, const hexWord& hW) {
	o << hW.hexWord1_ << hW.hexWord2_;
	return o;
}

// Generate an EOF hexRec.
hexRec::hexRec()
	:valid_(FALSE)
{
	update(String(":00000001FF"));
}

hexRec::hexRec(const String& aktLine)
	:valid_(FALSE)
{
	update(aktLine);
}

void hexRec::update(const String& aktLine)
{
	if ((aktLine.length() > MAXHEXRECSIZE) || (aktLine.length() < MINHEXRECSIZE))
	{
		valid_ = FALSE;
	} else {
		char* pAktLine = (char *)((const char *)(aktLine));
		valid_  = (bool)(*pAktLine++ == ':');
		size_   = hexByte(pAktLine); pAktLine+=2;
			valid_ = (bool)(size_.valid() && valid_);
		offset_ = hexWord(pAktLine); pAktLine+=4;
			valid_ = (bool) (offset_.valid() && valid_);
		type_   = hexByte(pAktLine); pAktLine+=2;
			valid_ = (bool) (type_.valid() && valid_);
		for (byte i = 0; i < size_.binvalue(); i++, pAktLine+=2) {
			hexRec_[i] = hexByte(pAktLine);
			valid_ = (bool) (hexRec_[i].valid() && valid_);
		}
		chk_    = hexByte(pAktLine);
			valid_ = (bool) (chk_.valid() && valid_);
			valid_ = (bool) (valid_ && checkChk());
	}
}

byte hexRec::calcChk() const {
	// Add over alle hexBytes
	uint offsetValue = offset_.binvalue();
	uint sumchk = size_.binvalue() + offsetValue%0x100 + offsetValue/0x100 + type_.binvalue();
	for (int i = 0; i < size_.binvalue(); i++) {
		sumchk += hexRec_[i].binvalue();
	}
	// 2's complement
	return (0x1000 - (sumchk % 0x100)) % 0x100;
}

void hexRec::update(const off_t aktOffset, const off_t aktSize, const char *pAktBuf) {
#ifdef __BORLANDC__
PRECONDITION(aktSize <= 16);
#endif
	off_t tmp;
	for (tmp = 0; tmp < aktSize; tmp++) {
		hexRec_[tmp] = hexByte((byte)*(pAktBuf + tmp));
	}
	
	offset_ = hexWord(aktOffset);
	size_   = hexByte(aktSize);
	type_   = hexByte((byte)0);
	chk_    = hexByte(calcChk());
}

ostream& operator<<(ostream& o, const hexRec& hR) {
	o << ':' << hR.size_ << hR.offset_ << hR.type_;
	for (int i = 0; i < hR.size(); i++) {
		o << hR.hexRec_[i];
	}
	o << hR.chk_;
	return o;
}

hexFile::hexFile()
	: fPtr(NULL)
	, EOF_(TRUE)
	, recOffset_(0), aktOffset_(0)
	, aktLen_(0), aktLineNum_(0)
	{ }

hexFile::hexFile(FILE *const pAktFile)
	: fPtr(pAktFile)
	, EOF_(FALSE)
	, recOffset_(0), aktOffset_(0)
	, aktLen_(0), aktLineNum_(0)
	{ }

readHexFile::readHexFile(istream& aktIn, core *const aktCore)
	: hexFile(NULL)
	, pCore(aktCore)
	, in(aktIn)
{
	hexFile::lastRecOffset_ = 0;
	hexFile::coreFilled_ = FALSE;
	acceptFile();
}

void readHexFile::acceptFile()
{
	while (FALSE == EOF_) {
		acceptLine();
		for(off_t i = 0; i < size(); i++) {
			pCore->insert(hexRec::getByte(i), recOffset_ + i);
		}
	}
	// Baustelle, spter verteilt acceptFile die Records auf die Buckets
	lastRecOffset_ = recOffset_;
}

void readHexFile::acceptLine()
{
	in.getline(aktLine, maxLineLen);
	if (in.fail() || in.eof()) {
		EOF_  = TRUE;
	} else {
		
/*
	// Should I worry about MSDog style lines?
	if (NULL == fgets(aktLine, maxLineLen, (FILE *)fPtr)) {
		EOF_ = TRUE;
	} else {
 */
		aktLineNum_++;
		for (int i = strlen(aktLine); i > MINHEXRECSIZE -1; i--) {
			if (aktLine[i-1] == '\r') {
				aktLine[i-1] = '\0';
			}
			break;
		}
		update(aktLine);
		if (TRUE == valid()) {
			switch (type()) {
			case 0:		recOffset_ = offset();
					break;
			// We just ignore hexRecs of type 2 or 3.
			case 3:		
					// fallthrough
			case 2: 	acceptLine();
					break;
			case 1: 	
					// fallthrough
			default:        EOF_ = TRUE;
					break;
			}

		} else {
			EOF_ = TRUE;
		}
	}
}

void readHexFile::getRecord()
{
	// Baustelle, spter holt getRecord die Records aus den Buckets
	acceptLine();
}


int readHexFile::getByte()
{
	int aktValue = 0x00;
	if (aktOffset_ > pCore->lastByte()) {
		EOF_ = TRUE;
		aktValue = EOF;
	} else {
		aktValue = pCore->get(aktOffset_++);
	}

	return aktValue;
}

writeHexFile::writeHexFile(ostream& aktOut, const core *const aktCore)
	: hexFile(NULL)
	, pCore(aktCore)
	, out(aktOut)
{
	hexFile::lastRecOffset_ = 0;
	hexFile::coreFilled_ = TRUE;
 	hexFile::aktOffset_  = pCore->firstByte();

	char aktBuf[MAXBINRECSIZE];
	off_t i, start_i, lastByte = pCore->lastByte();
	byte tmp;

	int aktSize;


// Output will ignore more than 2 \000's in a row.
	while (aktOffset_ <= lastByte) {
		for (	  aktSize = i = 0
			; (aktSize < 16) && (aktOffset_ + aktSize) <= lastByte
			; aktSize++) 
		{
			tmp = pCore->get(aktOffset_ + aktSize);
			if (0 == tmp) {
				start_i = i = aktSize;
				while( (i +1 < lastByte) && (0 == pCore->get(aktOffset_ +i +1)) ) {
					i++;
				}
				if (i > start_i) {
					break;
				}
			}
			aktBuf[aktSize] = tmp;
		}
		if (aktSize) {
			update(aktOffset_, aktSize, aktBuf);
			writeLine();
		}
		aktOffset_ += (i > aktSize) ? i +1 : aktSize; 
	}
}

void writeHexFile::writeLine() {
	
	out << (*(hexRec *)this) << "\n";

}
