
/*
 *    Copyright (C) 1996  Burkhard Kohl
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * 
 */

/*
 *	Main file for the hex2bin and bin2hex Intel hex conversion
 * 	utilities.
 *
 * 	$Id: hex2bin.c++,v 0.7 1996/12/07 20:29:42 buk Exp buk $
 * 	
 * 	$Log: hex2bin.c++,v $
 * 	Revision 0.7  1996/12/07 20:29:42  buk
 * 	Added O_TRUNC flag to open.
 *
 * 	Revision 0.6  1996/12/07 20:04:10  buk
 * 	Corrected typing error at line 38.
 *
 * 	Revision 0.5  1996/12/07 19:49:44  buk
 * 	Changed opening and handling of files.
 * 	Changed option and switches: Added offset and optional EOF hexRec.
 *
 * 	Revision 0.4  1996/12/05 16:50:32  buk
 * 	Added output of an EOF hexRec.
 *
 * 	Revision 0.3  1996/12/04 18:55:56  buk
 * 	Changed output from using File * to using ostream *.
 *
 * 	Revision 0.2  1996/12/02 19:44:48  buk
 * 	Adopted to duplicate usage as hex2bin and bin2hex.
 * 	Use of Class Getopt.
 *
 * 	Revision 0.1  1996/11/30 15:15:33  buk
 * 	Initial Revision.
 *
 *
 */

static char rcsid[] = "$Id: hex2bin.c++,v 0.7 1996/12/07 20:29:42 buk Exp buk $";


#include <GetOpt.h>
#include <stdio.h>
#include <fstream.h>
#include <errno.h>
#include <string.h>

#include "hexbin.h"
#include "core.h"

static void usage(char* callstr) { 
	cerr << "Usage :" << callstr << " [-n] [-o Offset] [-f OutputFile] [InputFile]\n";
	exit(-1);
}

int main(int argc, char *argv[]) {

    int optInd;
    off_t aktOffset = 0;
    String cmdname = argv[0];
    GetOpt getopt(argc, argv, "f:no:");

    String InFileName = ("stdin"), OutFileName = ("stdout");
    int istate, ostate, fdIn = 0, fdOut = 1;

    char  option_char;

    int eofFlag = TRUE;
    int hexInput;
    off_t userOffset = 0;
	

    while ((option_char = getopt()) != EOF) { 
	switch(option_char) {
		case 'f':	OutFileName = getopt.optarg;
				break;
		case 'n':	eofFlag = FALSE;
				break;
		case 'o':	
				errno = 0;
				userOffset = strtoul(getopt.optarg, NULL, 0);
				if (ERANGE == errno || userOffset > 0xFFFF) {
					cerr << "Invalid offset :" << userOffset << " specified.\n";
					return -5;
				}
				break;
		default:	usage(argv[0]);
				break;
	}
    }
    optInd = getopt.optind;

    if (argc == optInd+1) {
	InFileName = argv[optInd];
    } else if (argc < optInd +1) {
	// InFileName = "stdin";
    } else {
	usage(argv[0]);
	return -1;
    }

    if ("hex2bin" == common_suffix(cmdname, "hex2bin")) {
	hexInput = TRUE;
    } 
    else if ("bin2hex" == common_suffix(cmdname, "bin2hex")) {
	hexInput = FALSE;
    }
    else {
	cerr << argv[0] << " - unknown command invocation string.\n"; 
	cerr <<  "Rename executable file to hex2bin or bin2hex.\n";
	return -2;
    }

    if ("stdin" != InFileName) {
    	if (FALSE == hexInput)
#ifdef __BORLANDC__
		fdIn = open(InFileName, O_RDONLY | O_BINARY);
#else
		fdIn = open(InFileName, O_RDONLY);
#endif
     	else
		fdIn = open(InFileName, O_RDONLY);
    }
    if (-1 == fdIn) {
	cerr << argv[0] << " - error opening \"" << InFileName << "\": " << _sys_errlist[errno] << "\n";
	return -3;
    } 
    ifstream fIn = ifstream(fdIn);
    istate = fIn.rdstate();
    if (fIn.bad()) {
	cerr << argv[0] << " - error opening \"" << InFileName << "\": Stream unusable.\n";
	return -3;
    }
    
    if ("stdout" != OutFileName) {
    	if (TRUE == hexInput)
#ifdef __BORLANDC__
		fdOut = open(OutFileName, O_WRONLY | O_CREAT | O_TRUNC | O_BINARY);
#else
		fdOut = open(OutFileName, O_WRONLY | O_CREAT | O_TRUNC, 0666);
#endif
     	else
		fdOut = open(OutFileName, O_WRONLY | O_CREAT | O_TRUNC, 0666);
    }
    if (-1 == fdOut) {
	cerr << argv[0] << " - error opening \"" << OutFileName << "\": " << _sys_errlist[errno] << "\n";
	return -3;
    } 
    ofstream fOut = ofstream(fdOut);
    ostate = fOut.rdstate();
    if (fOut.bad()) {
	cerr << argv[0] << " - error opening \"" << OutFileName << "\": Stream unusable.\n";
	return -3;
    }
    
    core* pAktCore = new core;

    if (TRUE == hexInput) {
	readHexFile *pAktReadHexFile = new readHexFile(fIn, pAktCore);

	// We have to handle error conditions.
	if (!pAktReadHexFile->valid()) {
		cerr << InFileName << ": invalid hexrec at line " << pAktReadHexFile->line() << ".\n";
		return -4;
	}

	delete pAktReadHexFile;

	for (off_t i = 0; i < userOffset; i++) {
		fOut.put('\000');
	}
	aktOffset = pAktCore->firstByte();
	while (aktOffset <= pAktCore->lastByte()) {
		fOut.put(pAktCore->get(aktOffset++));
	}

    } 
    else if (FALSE == hexInput) {
	int tmp;

	aktOffset = userOffset;
	while ( EOF != (tmp = fIn.get())  ) {
		pAktCore->insert(tmp, aktOffset++);
	}
	writeHexFile *pAktWriteHexFile = new writeHexFile(fOut, pAktCore);

	// Output an EOF hexRec.
	if (TRUE == eofFlag)
		fOut << hexRec(String(":00000001FF")) << "\n";

	delete pAktWriteHexFile;
    } 

    return 0;
}
