/*
 *    Copyright (C) 1996  Burkhard Kohl
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 *	$Id: core.c++,v 0.2 1996/12/02 19:46:44 buk Exp buk $
 *
 *	$Log: core.c++,v $
 *	Revision 0.2  1996/12/02 19:46:44  buk
 *	Corrected static char rcsid[] statement.
 *
 *	Revision 0.1  1996/11/30 15:15:33  buk
 *	Initial Revision.
 *
 *
 */

static char rcsid[] = "$Id: core.c++,v 0.2 1996/12/02 19:46:44 buk Exp buk $";

#include "core.h"

core::core()
	: firstInst_(0x10000)
	, lastInst_(0)
{
	unsigned long int i;

	core_  = new byte[0x10000];
	active_= new byte[0x2000]; // 8 Active Flags group together
	for(i = 0; i < 0x2000; i++) {
		active_[i] = 0;
		core_[i]   = 0;
	}
	for(i = 0x2000; i < 0x10000; i++) {
		core_[i]   = 0;
	}
}

core::~core() {
	delete[] core_;
	delete[] active_;
}

void core::insert(const byte value, const off_t offset)
{
	*(core_ + offset) = value;
	*(active_ +(offset / 8)) |= 1 << ((offset % 8));
	if (offset < firstInst_)
		firstInst_ = offset;
	else if (offset > lastInst_)
		lastInst_ = offset;
}

bool core::active(const off_t offset)
{
	byte value = *(active_ + offset / 8);
	byte shift = (offset % 8);
	byte mask  = 1 << shift;

	return ((bool)(value & mask));
}
