#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <signal.h>

#include "../pc537.h"

int errno, fd, stop = 0;

struct sigaction sigusr1_act, sigint_act;

struct sigaction old_act;

struct readbuf rdb;

sigset_t block;

typedef void (*sighandler_t)(int);

void sigusr1_handler(int signum)
{

	if (SIGUSR1 == signum) {
		ioctl(fd, PC537_RDBUF, &rdb);
		printf("received Signal SIGUSR1 on intr %lu.\n", rdb.icnt);
	}
}

void sigint_handler(int signum)
{

	if (SIGINT == signum) {
		stop = 1;
	}
}



int main(void)
{

	int res = 0;
	long int icnt = 0; 
	sighandler_t old_handler; 
	sigset_t pending;
	unsigned char read = 0, t = 0, cnt;

	/* 
	 * First we have to handle SIGUSR1 so that the process
  	 * won't be aborted right after opening the device.
	 */
	sigusr1_act.sa_handler = sigusr1_handler;
	sigemptyset(&(sigusr1_act.sa_mask));
	sigusr1_act.sa_flags   = SA_RESTART;
	sigusr1_act.sa_restorer= NULL;
	res = sigaction(SIGUSR1, &sigusr1_act, &old_act);
	
	sigint_act.sa_handler = sigint_handler;
	sigemptyset(&(sigint_act.sa_mask));
	sigint_act.sa_flags   = SA_RESTART;
	sigint_act.sa_restorer= NULL;
	res = sigaction(SIGINT, &sigint_act, &old_act);
	
	fd = open("/dev/pc537", O_RDWR);
	if (fd < 0) {
		perror("Unable to open");
		return -1;
	}

	res = ioctl(fd, PC537_RESTART);

	for (t = 0; t < 255; t++) {
		if (stop)
			break;
		res = ioctl(fd, PC537_WRCPORT, t);
		res = ioctl(fd, PC537_MCINT0);

		sleep(1);

		if (rdb.icnt > icnt) {
			icnt = rdb.icnt;
			printf("Sent 0x%2.2x, got 0x%2.2x on intr %lu.\n", t, rdb.val, rdb.icnt);
		}
	}

	res = ioctl(fd, PC537_RESET);

	close(fd);

	res = sigaction(SIGUSR1, &old_act, NULL);

	return 0;

}

	
