#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <signal.h>

#include "../pc537.h"

int errno;

int sig = 0;

typedef void (*sighandler_t)(int);

void pc537_handler(int signum)
{

	if (SIGUSR1 == signum) {
		printf("Received signal SIGUSR1.\n");
		sig = 1;
	}
}


int main(void)
{

	int fd;
	int tmp, result, i;
	sighandler_t old_handler; 

	/* 
	 * First we have to ignore SIGUSR1 so that the process
  	 * won't be aborted right after opening the device.
	 */
	old_handler = signal(SIGUSR1, pc537_handler);	


	fd = open("/dev/pc537", O_RDWR);
	if (fd < 0) {
		perror("Unable to open");
		return -1;
	}

	result = ioctl(fd, PC537_RESET);

	close(fd);

	(void) signal(SIGUSR1, old_handler);

	return 0;

}
