#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <signal.h>

#include "../pc537.h"

int errno, fd;

struct sigaction pc537_act;

struct sigaction old_act;

struct readbuf rdb;

sigset_t block;

typedef void (*sighandler_t)(int);

void pc537_handler(int signum)
{

	if (SIGUSR1 == signum) {
		ioctl(fd, PC537_RDBUF, &rdb);
		printf("received Signal SIGUSR1 on intr %lu.\n", rdb.icnt);
	}
}


int main(void)
{

	int res = 0;
	long int icnt = 0; 
	sighandler_t old_handler; 
	sigset_t pending;
	unsigned char read = 0, write = 0, cnt;

	/* 
	 * First we have to handle SIGUSR1 so that the process
  	 * won't be aborted right after opening the device.
	 */
	pc537_act.sa_handler = pc537_handler;
	sigemptyset(&(pc537_act.sa_mask));
	pc537_act.sa_flags   = SA_RESTART;
	pc537_act.sa_restorer= NULL;
	res = sigaction(SIGUSR1, &pc537_act, &old_act);
	
	sigemptyset(&block);
	sigaddset(&block, SIGUSR1);


	fd = open("/dev/pc537", O_RDWR);
	if (fd < 0) {
		perror("Unable to open");
		return -1;
	}

	res = ioctl(fd, PC537_RESTART);

	for (cnt = 0; cnt < 0xff; cnt++) {

		write = cnt -100;
		res = ioctl(fd, PC537_WRCPORT, &write);

		/* Hier sollte mc mit Interrupt quittieren */
		res = ioctl(fd, PC537_MCINT0);
#if 0
		printf("write: %u, icnt: %lu, rdb.icnt: %lu.\n", write, icnt, rdb.icnt);
#endif
		if (rdb.icnt > icnt) {
			icnt = rdb.icnt;
			printf("Sent %u, got %u on intr %lu.\n", write, rdb.val, rdb.icnt);
		}

		sleep(1);
		sigpending(&pending);
		if (sigismember(&pending, SIGUSR1)) {
			printf("Second interrupt %lu on pass %u.\n", rdb.icnt, cnt);
			icnt = rdb.icnt;
			sigprocmask(SIG_UNBLOCK, &block, NULL);
		}

		/* Und hiervor sollte noch ein zweiter erfolgt sein */
		res = ioctl(fd, PC537_RDCPORT, &read); 

		res = ioctl(fd, PC537_MCINT1);
	}

	res = ioctl(fd, PC537_RESET);

	close(fd);

	res = sigaction(SIGUSR1, &old_act, NULL);

	return 0;

}

	
