/*
 *    Copyright (C) 1996  Burkhard Kohl
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *	
 * 	Header file for the driver of Feger+Co PC537-Addin board.
 *
 *	$Log: pc537.h,v $
 *	Revision 0.12  1996/12/07 23:00:37  buk
 *	Dummy update.
 *
 *	Revision 0.11  1996/10/26 16:51:34  buk
 *	Changed struct pc537 member int lastaddr to off_t endaddr.
 *
 *	Revision 0.10  1996/10/13 17:12:30  buk
 *	Changed the naming of ioctl cmds.
 *
 *	Revision 0.9  1996/10/06 00:08:46  buk
 *	Changed PC537_RDBUF to PC537_RDIBUF to reflect the fact, that
 *	it is an interrupt buffer.
 *	Added "ready" and "wait" to the pc537_struct for select() support.
 *
 *	Revision 0.8  1996/10/05 15:16:07  buk
 *	Dummy update.
 *
 *	Revision 0.7  1996/10/04 22:47:37  buk
 *	Dummy increment.
 *
 *	Revision 0.6  1996/10/04 19:06:01  buk
 *	Added GNU GPL.
 *	Changed K-Port to C-Port and renamed IOCTL cmds.
 *
 *	Revision 0.5  1996/10/01 21:59:25  buk
 *	Introduced struct readbuf for the PC537_RDBUF ioctl.
 *	Changed definition of struct irqbuf.
 *
 *	Revision 0.4  1996/09/22 22:28:39  buk
 *	Changed f_owner to pid in pc537_struct.
 *
 *	Revision 0.3  1996/09/21 22:01:36  buk
 *	IOCTL cmds added.
 *	IRQ buffer and struct decls.
 *	pc537_struct decl for interrupt handler.
 *
 *	Revision 0.2  1996/09/14 21:49:00  buk
 *	PC537_LASTADDR changed to 0x1fff which reflects the amount of ram
 *	on my Addinboard.
 *
 *	IOCTL defines for restarting/resetting, reading/writing the C-Port
 *	and for raising interrupts 0/1 mc interrupts 0/1 added.
 *	Using IOCTL number 0x99 1 through 6.
 *	Revision 0.1  1996/08/31 08:07:16  buk
 *	Initial version.
 * 
 */

#ifndef PC537_H
#define PC537_H

#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE !FALSE
#endif

#include <linux/ioctl.h>

/*
 *	Nr of IO-base ports
 */
#define PC537_IOPORTS 4

/*
 * 	This struct is used by 
 *	the PC537_RDIBUF ioctl.
 */
struct readbuf {
	unsigned char val;	/* The result of C-Port read */
	unsigned long icnt;     /* valid interrupt count numbers start with 1 */
};

/*
 *	Defines for the ioctl's.
 * 	We use ioctl 0x99 0x0 through 0x9. Do not forget to register.
 */
#define PC537_RDIBUF		_IOWR(0x99, 0, struct readbuf )
#define PC537_RESTART		_IO (0x99, 1)
#define PC537_RESET		_IO (0x99, 2)	
#define PC537_RDCPORT 		_IOR(0x99, 3, char)	
#define PC537_WRCPORT		_IOW(0x99, 4, char)	
#define PC537_MCINT0		_IO (0x99, 5)
#define PC537_MCINT1		_IO (0x99, 6)	

/*
 *	4 possible IRQ lines combined 
 * 	with 4 possible Base addresses
 */
#define PC537_MAXBOARDS		16

/*
 *	IRQ Buffer related 
 */
#define PC537_IBUFSIZE		16

struct irqbuf {
	unsigned long icnt;
	int   bpos;		/* Obsolete now, using icnt instead */
	unsigned char *bptr;
};
	


struct pc537_struct {
	int    irq;
	int    base;
	off_t  endaddr;
	int    memtype;
	struct irqbuf ibuf;
	pid_t  pid; 		/* pid of the opening process */
	int    ready;		/* used for select(). */
	struct wait_queue *wait; 
};

#endif  /* PC537_H */
