#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <signal.h>

#include "../pc537.h"

int errno, fd, stop = 0;

struct sigaction sigusr1_act, sigint_act;

struct sigaction old_act;

struct readbuf rdb;

sigset_t block;

typedef void (*sighandler_t)(int);

void sigusr1_handler(int signum)
{

	if (SIGUSR1 == signum) {
#if 0
		ioctl(fd, PC537_RDIBUF, &rdb);
#endif
		printf("received Signal SIGUSR1 on intr %lu.\n", rdb.icnt);
	}
}

void sigint_handler(int signum)
{

	if (SIGINT == signum) {
		stop = 1;
	}
}



int main(int argc, char *argv[])
{

	int res = 0;
	long int icnt = 0; 
	sighandler_t old_handler; 
	sigset_t pending;
	unsigned char read = 0, t = 100, cnt;
	fd_set rfds;
	struct timeval tv;

	/* 
	 * First we have to handle SIGUSR1 so that the process
  	 * won't be aborted right after opening the device.
	 */
	sigusr1_act.sa_handler = sigusr1_handler;
	sigemptyset(&(sigusr1_act.sa_mask));
	sigusr1_act.sa_flags   = SA_RESTART;
	sigusr1_act.sa_restorer= NULL;
	res = sigaction(SIGUSR1, &sigusr1_act, &old_act);
	
	sigint_act.sa_handler = sigint_handler;
	sigemptyset(&(sigint_act.sa_mask));
	sigint_act.sa_flags   = SA_RESTART;
	sigint_act.sa_restorer= NULL;
	res = sigaction(SIGINT, &sigint_act, &old_act);

	if (argc > 1)
		t = atoi(argv[1]);
	
	fd = open("/dev/pc537", O_RDWR);
	if (fd < 0) {
		perror("Unable to open");
		return -1;
	}

	res = ioctl(fd, PC537_RESTART);
	res = ioctl(fd, PC537_WRCPORT, t);
	res = ioctl(fd, PC537_MCINT0);
	sleep(1);
	if (rdb.icnt > icnt) {
		icnt = rdb.icnt;
		printf("Got %u on intr %lu.\n", rdb.val, rdb.icnt);
	}
	sleep(1);

	while (1) {
		if (stop)
			break;
		FD_ZERO(&rfds);
		FD_SET(fd, &rfds);
		tv.tv_sec = 1;
		tv.tv_usec= 0;
		res = select(fd +1, &rfds, NULL, NULL, &tv);
		if (res && FD_ISSET(fd, &rfds)) {
			res = ioctl(fd, PC537_RDIBUF, &rdb);
			printf("Got %u on intr %lu.\n", rdb.val, rdb.icnt);
		}  else {
			printf("select() timed out after %3.3d%3.3d secs.\n", tv.tv_sec, tv.tv_usec);
		}
		res = ioctl(fd, PC537_MCINT1);
	}

	res = ioctl(fd, PC537_RESET);

	close(fd);

	res = sigaction(SIGUSR1, &old_act, NULL);

	return 0;

}

	
