#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <signal.h>

#include "../pc537.h"

int errno;

struct sigaction pc537_act;

struct sigaction old_act;

struct readbuf rdb;

typedef void (*sighandler_t)(int);

void pc537_handler(int signum)
{

	if (SIGUSR1 == signum) {
		printf("Received signal SIGUSR1.\n");
	}
}


int main(void)
{

	int fd;
	long int tmp; 
	int result;
	sighandler_t old_handler; 
	sigset_t pending;
	unsigned char read = 0;

	/* 
	 * First we have to ignore SIGUSR1 so that the process
  	 * won't be aborted right after opening the device.
	 */
	pc537_act.sa_handler = pc537_handler;
	sigemptyset(&(pc537_act.sa_mask));
/*	sigaddset(&(pc537_act.sa_mask), SIGUSR1); */
	pc537_act.sa_flags   = SA_RESTART;
	pc537_act.sa_restorer= NULL;
	result = sigaction(SIGUSR1, &pc537_act, &old_act);

#if 0
	old_handler = signal(SIGUSR1, pc537_handler);	
#endif


	fd = open("/dev/pc537", O_RDWR);
	if (fd < 0) {
		perror("Unable to open");
		return -1;
	}

	result = ioctl(fd, PC537_RESTART);

	result = ioctl(fd, PC537_WRCPORT, 0xff);

	/* Hier sollte mc mit Interrupt quittieren */
	result = ioctl(fd, PC537_MCINT0);

	result = ioctl(fd, PC537_RDBUF, &rdb);


	sleep(1);
	/* Und hiervor sollte noch ein zweiter erfolgt sein */
	result = ioctl(fd, PC537_RDCPORT, &read); 

	result = ioctl(fd, PC537_MCINT1);

	result = ioctl(fd, PC537_RESET);

	close(fd);

	result = sigaction(SIGUSR1, &old_act, NULL);
	(void) signal(SIGUSR1, old_handler);

	return 0;

}

	
