$processor(80537)
;
;       cport.asm, Burkhard Kohl (c) 1996
;       for Feger + Co 537 or 537LWL addin board
;************************************************
; PC writes to MC:
;       IO_INT0 raised by PC after writing to
;       c-port.
;
;       MC ackknowledges with PC-interrupt 
;       returning complemented byte.
;
; MC writes to PC
;       MC writes byte to c-port
;       and signals with PC-interrupt.
;       
;       PC reads c-port and acknowledges with
;       IO_INT1.
;************************************************
;
;       Registers used: 
;       R7    : stores byte from PC 
;
;       R6    : stores byte written by MC
;
;       P6.7  : reset flipflop for mc int
;               1 = no reset
;               0 = reset
;       P6.6  : raise PC interrupt
;               1 = no interrupt
;               0 = interrupt
;       P6.5  : c-port store signal
;               1 = none
;               0 = store P4 to c-port
;       P6.4  : c-port access
;               1 = PC has c-port access
;               0 = MC has c-port access
;
;       P4    : IO-port to c-port
;
;       flags used with PC/MC communication
; byte written by PC to c-port
pc_byte  BIT  00h       ;set by IO_INT0
			;reset by prog reading byte from c-port
; byte written by MC to c-port
mc_byte   BIT 01h       ;set when writing to c-port
			;reset by IO_INT1
; set by timer, signals to write new byte to PC
timer_set BIT 02h
;**************************************
t0rel   EQU     0FA23h ;Reload value for timer0 - 1/1000s at 18 MHz
t0div   EQU     0Ah    ;Stretch timer to 10ms 

CSEG AT RESET
	ljmp    start

;ext int 0
org 03h
	jmp             IO_INT0
;timer 0 int
org 0bh
	jmp             TIMER_0
;ext int 1
org 13h
	jmp             IO_INT1

;**************************************
;       interrupt service routines
org 100h

IO_INT0:
	clr     eal
	push    psw
	push    acc

	anl     p6,#01111111b   ;reset ext. interrupt flipflop
	orl     p6,#10000000b

	;We don't want to read a byte from c-port
	;if the last one has not been readily processed
	jb      pc_byte,INT0_exit

	mov     p4,#0FFh        ;allow input to P4
	anl     p6,#11101111b   ;take c-port access for MC
				;and connect c-port to P4
	mov     a,p4            ;read from c-port
	orl     p6,#00010000b   ;give c-port access to PC
	
	mov     r7,a            ;store byte from pc
	cpl     a               ;return complemented byte         
	mov     p4,a 
	anl     p6,#11011111b   ;store p4 to c-port
	orl     p6,#00100000b
	
	setb    pc_byte
	anl     p6,#10111111b   ;raise PC int
	orl     p6,#01000000b

INT0_exit:
	pop     acc
	pop     psw
	setb    eal
	reti

;**************************************
IO_INT1:
	clr     eal
	push    psw
	push    acc

	anl     p6,#01111111b   ;reset ext. interrupt flipflop
	orl     p6,#10000000b

	clr     mc_byte
	pop     acc
	pop     psw
	setb    eal
	reti

;**************************************
TIMER_0:
	clr     eal
	clr     tr0
	mov     tl0,#(LOW  t0rel)
	mov     th0,#(HIGH t0rel)
	setb    tr0

	push    psw
	push    acc

	;stretch to 10 ms
	djnz    r5,timer_0_exit
	mov     r5,#t0div

	;stretch with byte read from PC
	djnz    r4,timer_0_exit
	mov     a,r7
	mov     r4,a

	jb      mc_byte,TIMER_0_EXIT
	dec     r6
	setb    timer_set

TIMER_0_EXIT:        
	pop     acc
	pop     psw
	setb    eal
	reti
;**************************************

;       write byte from accu to c-port:

write_cport:
	mov     p4,a
	anl     p6,#11011111b   ;store in c-port
	orl     p6,#00100000b
	setb    mc_byte       
	anl     p6,#10111111b   ;raise PC int
	orl     p6,#01000000b   ;

	ret

;**************************************
;       main program

start:
;       initialize flags and flipflop:
	clr     pc_byte
	clr     mc_byte
	clr     timer_set

	anl     p6,#01111111b ;reset interrupt flipflop
	orl     p6,#10000000b

	mov     r7,#00h
	mov     r6,#00h

;        setb    it0     ;interrupt on falling edge
	setb    ex0     ;allow ext. int 0
;        setb    it1     ;interrupt on falling edge
	setb    ex1     ;allow ext. int 1
	setb    et0     ;allow timer0 int
	setb    eal     ;allow interrupts
	setb    tr0     ;start timer0

loop:
	jnb     pc_byte,write   ;wait for byte from PC
	mov     a,r7
	clr     pc_byte
	clr     et0             ;set new timing to val from PC
	mov     r5,#01h
	mov     r4,a
	inc     r4
	setb    et0
				;wait and process byte
write:
	jb      mc_byte,loop    ;wait for IO_INT1 acknowledge from PC
	jnb     timer_set,loop
	mov     a,r6
	clr     timer_set
	lcall   write_cport
	jmp     loop
END
