/******************************************************************************
 *
 *	i8255 Loadable Module for Linux
 *
 *
 * $Id: i8255.h,v 1.10 1998/10/14 20:28:20 sanne Exp $
 *
 * Copyright (c) 1998 by Sanne Graaf (sanne@mmm.xs4all.nl). 
 *   All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************************************/
#ifndef INCLUDED_8255_DRIVER
   #define INCLUDED_8255_DRIVER

   #define MAX_DEVICES 		10	         /* max number of 8255's */


/******************************************************************************
 * Functions
 *
 */

   #define I8255_RESET        	0	         /* RESET/INIT CARD	*/
   #define I8255_DEBUG		1		 /* Set Debug level	*/
   #define I8255_EXCL		2		 /* Set Device Exclusive*/
   #define I8255_TEST	   	3	         /* Display all values in syslog*/

   #define I8255_READ		4	         /* Read i8255 Register	*/
   #define I8255_WRITE	   	5	         /* Write i8255 Register*/

   #define I8255_SETBIT      	6	         /* Set one bit on i8255*/
   #define I8255_CLRBIT	   	7	         /* Clear one bit on i8255*/
   #define I8255_READBIT     	8	         /* Read one bit on i8255*/


/******************************************************************************
 * Register Mask bits and status register masks
 *
 */

   #define BIT0			0xFE	/* inverse mask bit 0	*/
   #define BIT1			0xFD	/*			*/
   #define BIT2			0xFB	/*			*/
   #define BIT3			0xF7	/*			*/
   #define BIT4			0xEF	/*			*/
   #define BIT5			0xDF	/*			*/
   #define BIT6			0xBF	/*			*/
   #define BIT7			0x7F	/* inverse mask bit 7	*/

   #define I8255_USED		0x01	/* 8255 is in use	*/
   #define I8255_IRQOK		0x02	/* IRQ is configured	*/
   #define I8255_PORTOK		0x04	/* IO port configures	*/

/******************************************************************************
 * Various defines
 *
 */

   #ifdef GENERIC_I8255

      #define DEV_NAME  "i8255"
      #define I8255_PORTNUM		4	        /* 8255 number of ports	*/
   
      #define I8255_MAJOR		64	        /* device major number	*/

      #define REG_A0			0		/* Reg A0 offset*/
      #define REG_B0			1		/* Reg B0 offset*/
      #define REG_C0			2		/* Reg C0 offset*/
      #define REG_D0			3		/* Reg D0 offset*/

      #define I8255_A0(num) 		num+REG_A0       /* 8255 port A	*/
      #define I8255_B0(num) 		num+REG_B0   	 /* 8255 port B	*/
      #define I8255_C0(num) 		num+REG_C0   	 /* 8255 port C	*/
      #define I8255_D0(num) 		num+REG_D0	 /* 8255 status register*/

   #endif

   #ifdef ADVANTECH_PCL731
      
      #define DEV_NAME  "pcl731"
      #define I8255_PORTNUM		8	        /* 8255 number of ports	*/

      #define I8255_MAJOR		63	        /* device major number	*/
      
      #define REG_A0			0		/* Reg A0 offset*/
      #define REG_B0			1		/* Reg B0 offset*/
      #define REG_C0			2		/* Reg C0 offset*/
      #define REG_D0			3		/* Reg D0 offset*/
      #define REG_A1       		4		/* Reg A1 offset*/
      #define REG_B1       		5		/* Reg B1 offset*/
      #define REG_C1       		6		/* Reg C1 offset*/
      #define REG_D1       		7		/* Reg D1 offset*/

      #define I8255_A0(num) 		num+REG_A0      /* 8255 port A	*/
      #define I8255_B0(num) 		num+REG_B0  	/* 8255 port B	*/
      #define I8255_C0(num) 		num+REG_C0  	/* 8255 port C	*/
      #define I8255_D0(num) 		num+REG_D0    	/* 8255 status register	*/
      #define I8255_A1(num) 		num+REG_A1      /* 8255 port A	*/
      #define I8255_B1(num) 		num+REG_B1  	/* 8255 port B	*/
      #define I8255_C1(num) 		num+REG_C1  	/* 8255 port C	*/
      #define I8255_D1(num) 		num+REG_D1    	/* 8255 status register	*/

   #endif

   #ifdef ADVANTECH_PCM3724
      
      #define DEV_NAME  "pcm3724"
      #define I8255_PORTNUM		10	        /* 8255 number of ports	*/
      
      #define I8255_MAJOR		62	        /* device major number		*/
      
      #define REG_A0			0		/* Reg A0 offset*/
      #define REG_B0			1		/* Reg B0 offset*/
      #define REG_C0			2		/* Reg C0 offset*/
      #define REG_D0			3		/* Reg D0 offset*/
      #define REG_A1       		4		/* Reg A1 offset*/
      #define REG_B1       		5		/* Reg B1 offset*/
      #define REG_C1       		6		/* Reg C1 offset*/
      #define REG_D1       		7		/* Reg D1 offset*/

      #define REG_DIR      8     /* Direction Reg found on a pc/104 board */
      #define REG_GATE     9     /* Gate Register found on a pc/104 board */

      #define I8255_A0(num) 		num+REG_A0     	/* 8255 port A*/
      #define I8255_B0(num) 		num+REG_B0  	/* 8255 port B*/
      #define I8255_C0(num) 		num+REG_C0  	/* 8255 port C*/
      #define I8255_D0(num) 		num+REG_D0      /* 8255 status register	*/
      #define I8255_A1(num) 		num+REG_A1      /* 8255 port A*/
      #define I8255_B1(num) 		num+REG_B1  	/* 8255 port B*/
      #define I8255_C1(num) 		num+REG_C1  	/* 8255 port C*/
      #define I8255_D1(num) 		num+REG_D1      /* 8255 status register	*/

      #define I8255_DIR(num)     num+REG_DIR     /* PCM3724 Direction Register */
      #define I8255_GATE(num)    num+REG_GATE    /* PCM3724 Gate Register */

   #endif

   #define ON			1               /* general ON	*/
   #define OFF			0               /* general OFF	*/

   #define I8255_VERSION	"0.2"		/* version number */

/******************************************************************************
 *  General Structures
 *
 *
 */

struct i8255_struct {            	/* communication struct	     */
   int regnum;               		/* register (REG_A0 ..)      */
   u_char value;          		/* value to write	     */
   u_char bitno;          		/* bitmask for set/clr bit   */
};

struct i8255_cfg {            		/* One 8255 Cfg structure    */
   int iobase;               		/* 8255 IO base address	     */
   int irq;               		/* 8255 IRQ number	     */
   u_char data_regs[I8255_PORTNUM];     /* current register values   */
   u_char i8255stat;            	/* bitmapped status byte     */
   u_char exclusive;            	/* allow multi usage or not  */
   u_char usenum;            		/* number of uses	     */
};


static struct i8255_cfg i8255_dev[MAX_DEVICES]; /* i8255 config struct array */
static struct wait_queue *i8255_wait;

   #ifdef __KERNEL__


/******************************************************************************
 *  Module Function Prototypes.
 *
 */

static int i8255_read(struct inode *inode, struct file *file, char *buffer, int count);
static int i8255_open(struct inode *inode, struct file *file);
static int i8255_write(struct inode *inode, struct file *file, const char *buffer, int count);
static int i8255_ioctl(struct inode *inode, struct file *file, u_int cmd, u_long arg);
static void i8255_release(struct inode *inode, struct file *file);

/******************************************************************************
 * /proc/i8255 stuff
 *
 */ 
static int i8255_get_info(char *, char**, off_t, int, int);

static struct proc_dir_entry i8255_proc_entry = {
    0, 5, "i8255", S_IFREG | S_IRUGO, 0, 0, 0, 0, NULL, i8255_get_info, NULL,
    NULL, NULL, NULL
};



/******************************************************************************
 *  Module file operation structure.
 *
 *
 */

struct file_operations i8255_fops = {
   NULL,                /* lseek 		*/
   i8255_read,          /* read			*/
   i8255_write,         /* write		*/
   NULL,                /* readdir		*/
   NULL,                /* select		*/
   i8255_ioctl,         /* ioctl		*/
   NULL,                /* mmap			*/
   i8255_open,          /* open			*/
   i8255_release,       /* release		*/
   NULL,                /* fsync		*/
   NULL,                /* fasync		*/
   NULL,                /* check_media_change 	*/
   NULL,                /* revalidate		*/
};

   #endif //__KERNEL__
#endif //INCLUDED_8255_DRIVER
