/* ------------------------------------------------------------------------- */
/* 									     */
/* tcl_chrord.c - two new commands for Tcl/Tk to translate int<->char	     */
/* 									     */
/* ------------------------------------------------------------------------- */
/*   Copyright (C) 1995 Simon G. Vogl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		     */
/* ------------------------------------------------------------------------- */
#include <tcl.h>
#include <tk.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>

int ChrOrdCmd(ClientData dummy, Tcl_Interp *interp,int argc, char **argv){
	int i,ret;
	char buf[4];
	if ( argc<2 ){
		if (argv[0][0]=='c')
			interp->result="Usage: chr int ?... int?";
		else
			interp->result="Usage: ord char ?... char?";
	}
	switch (argv[0][0]){
		case 'c':
			i=1;
			argc--;
			while (argc){
				argc--;
				if (TCL_OK!=Tcl_GetInt(interp,argv[i],&ret)) {
					return TCL_ERROR;
				}
				if (ret<0 || ret>255) {
					sprintf(interp->result,"chr: Value out of range (was %d)",ret);
					return TCL_ERROR;
				}
				sprintf(buf,"%c",ret);
				Tcl_AppendResult(interp,buf,(char*)NULL);
				if (argc)
					Tcl_AppendResult(interp," ",(char*)NULL);
				i++;
			}
			break;
		case 'o':
			i=1;
			argc--;
			while (argc){
				argc--;
				/* only give warning if string >1 && ! empty! */
	                        if (argv[i][0] && strlen(argv[i])!=1){
        	                        interp->result="arguments should be chars!";
                	                return TCL_ERROR;
                        	}
				sprintf(buf,"%d",(unsigned char)argv[i][0]);
				Tcl_AppendResult(interp,buf,(char*)NULL);
				if (argc)
					Tcl_AppendResult(interp," ",(char*)NULL);
				i++;
			}
			break;
		default:
			/* this should never! happen... */
	}
	return TCL_OK;
}



void ChrOrdInit (Tcl_Interp *interp) {

	Tcl_CreateCommand(interp, "chr", ChrOrdCmd, (ClientData) 0,
            (Tcl_CmdDeleteProc *) NULL);
        Tcl_CreateCommand(interp, "ord", ChrOrdCmd, (ClientData) 0,
            (Tcl_CmdDeleteProc *) NULL);
};

