/* ------------------------------------------------------------------------- */
/* detect -- look who's there. Gets address acks from all devices on the bus.*/
/*		It should not change any values in the peripherals.	     */
/* ------------------------------------------------------------------------- */
static char *rcsid="$Id: detect.c,v 2.2 1996/11/17 22:03:06 i2c Exp $";
/*
 * $Log: detect.c,v $
 * Revision 2.2  1996/11/17 22:03:06  i2c
 * changed timing
 *
 * Revision 2.1  1996/11/17 13:51:19  i2c
 * Updated for new addressing scheme.
 *
 * Revision 1.1  1996/07/23 21:35:58  i2c
 * Initial revision
 *
 * Revision 1.2  1996/07/06 17:20:38  i2c
 * rewrote loop
 *
 * Revision 1.1  1996/03/15 08:55:53  root
 * Initial revision
 *
 */
 
#include <unistd.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <stdio.h>
#include <errno.h>
#include <linux/delay.h>
#include "i2c.h"
#include <unistd.h>

#define Write(a,b,c)	err(1,write(a,b,c))
#define Read(a,b,c)	err(0,read(a,b,c))

void err(int wr, int d){
	if (d==-1){
		printf("%s error: %s !\n",(wr)?"Write":"Read",strerror(errno));
	}
}

int main(int argc, char *argv[]){
	int i,f;
	char b[40],c[40]="  abccdefghijklmn";
	c[0]=160; c[1]=0;
	b[0]=160;
	
	f=open("/dev/i2c0",O_RDWR);
	if (f<0){
		printf("open error!\n");
		exit(1);
	}
	ioctl(f,I2C_UDELAY,140);
	ioctl(f,I2C_MDELAY,120);
        ioctl(f,I2C_RETRIES,3);
         	
	for (i=4;i<256;i+=2){
		ioctl(f,I2C_SLAVE,i);
		if (0>read (f,b,1) ) {
			putchar('.');
		} else {
			printf("\n%d worked! \n",i&0xfe);
		}
		usleep(1000);
		fflush(stdout);
	}
	putchar('\n');
	return close(f);
}
