/* med.c - make eprom disk image from ramdisk image */

#include <stdio.h>
#include <string.h>

#define    DISK_SIZE    (6291456)
#define    NUM_SECT    (DISK_SIZE/512)

void write_eprom_image(FILE *fi, FILE *fo);

int main(int ac, char **av)
{
    FILE    *fi,
            *fo;

    char    fin[44],
            fon[44];

    if (ac > 1) {
        strcpy(fin,av[1]);
    } else {
        strcpy(fin,"hda3.ram");
    }

    if (ac > 2) {
        strcpy(fon,av[2]);
    } else {
        strcpy(fon,"hda3.eprom");
    }

    fi    = fopen(fin,"r");
    fo    = fopen(fon,"w");

    if (fi == 0 || fo == 0) {
        printf("Can't open files\n");
        exit(0);
    }

    write_eprom_image(fi,fo);

    fclose(fi);
    fclose(fo);
}

void write_eprom_image(FILE *fi, FILE *fo)
{
    char    *ini;
    char    *outi;    /* In and out images */
    short    *smap;    /* Sector map */
    char    *sp;
    char    c = 0;

    struct {
        unsigned short    version;
        unsigned short    blocks;
        unsigned short    sect_ofs;
    } hdr;
    
    int    ns,
        s,
        i,
        fs;

    ini     = (char *)malloc(DISK_SIZE);    /* Max disk size is currently 6M */
    outi    = (char *)malloc(DISK_SIZE);    /* Max disk size is currently 6M */
    smap    = (short *)malloc(NUM_SECT*sizeof(short));

    if (ini == NULL || outi == NULL || smap == NULL) {
        printf("Can't allocate memory :(\n");
        exit(0);
    }

    if (DISK_SIZE != fread(ini,1,DISK_SIZE,fi)) {
        printf("Can't read input file :(\n");
        exit(0);
    }

    memcpy(outi,ini,512);    /* Copy in first sector */
    smap[0]    = 0;
    ns        = 1;            /* Number of sectors in outi */

    for(i=1;i<NUM_SECT;i++) {    /* Map each sector into outi */
        sp    = ini+i*512;
        for(s=0;s<ns;s++) {
            if (0 == memcmp(sp,outi+s*512,512)) {    /* Found = sector */
                break;
            }
        }
        if (s==ns) {
            memcpy(outi+ns*512,sp,512);    /* Copy in new sector */
            ns    += 1;
        }
        smap[i]    = s;
    }

/* Filler - make sectors start on 512 byte boundry */

    fs    = 512 - ((sizeof(hdr) + sizeof(short)*NUM_SECT) % 512);

    hdr.version        = 2;
    hdr.blocks        = NUM_SECT;
    hdr.sect_ofs    = sizeof(hdr) + sizeof(short)*NUM_SECT + fs;

    fwrite(&hdr,sizeof(hdr),1,fo);            /* header info */
    fwrite(smap,sizeof(short),NUM_SECT,fo);    /* Sector Map */
    for(i=0;i<fs;i++) {
        fwrite(&c,1,1,fo);    /* Filler - sectors start on 512 byte boundry */
    }
    fwrite(outi,512,ns,fo);                    /* Output Sectors */
}
