#ifndef _LINUX_DAS8_H
#define _LINUX_DAS8_H

/* ioctl commands */
#define DAS8_SETC_AD 0x1            /* set current A/D channel */
#define DAS8_SETC_DA 0x2            /* set current D/A channel */
#define DAS8_SETR_AD 0x3            /* set A/D conversion resolution */
#define DAS8_SETG_AD 0x4            /* set input gain */
#define DAS8_GETV_AD 0x5            /* get A/D conversion result */
#define DAS8_PUTV_DA 0x6            /* enter D/A output */

/* resolution settings */
#define DAS8_8BIT    0x1
#define DAS8_12BIT   0x2

/* gain settings */
#define DAS8_BI_5V    0x0
#define DAS8_BI_10V   0x8
#define DAS8_UNI_10V  0x9
#define DAS8_BI_05V   0xa           /* 0.5 V */
#define DAS8_UNI_1V   0xb
#define DAS8_BI_005V  0xc           /* 0.05 V */
#define DAS8_UNI_01V  0xd           /* 0.1 V */
#define DAS8_BI_001V  0xe           /* 0.01 V */
#define DAS8_UNI_002V 0xf           /* 0.02 V */

#ifdef __KERNEL__

#ifndef DAS8_BASE
#define	DAS8_BASE		0x300
#endif

#ifndef DAS8MAJOR
#define DAS8MAJOR	60
#endif

struct DAS8_t {
  int major;		/* Major # for this card	*/
  int present;          /* A DAS8 card is present	*/
  int open;		/* The device is open		*/
  int stat;		/* Device status		*/
  int base;		/* Base address of card		*/
  int cur_ad;           /* current A/D channel */
  int cur_da;           /* current D/A channel */
  int resol;            /* input resolution */
  int gain;             /* current (input) gain */
};

#endif

#endif

