/*
	simulate interrupt on IRQ driver

	(C) 1997 Dmitry A. Fedorov, fedorov@inp.nsk.su
	Copying-policy: LGPL

	$Id: irqsim.c,v 1.8 2001/11/21 05:08:16 fedorov Exp $

	tab size = 4
*/

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <fcntl.h>		/* open */
#include <signal.h>
#include <unistd.h>
#include <string.h>		/* strerror */
#include <irq.h>


static int Usage(const char* progname)
{
	fprintf(stderr, "Usage: %s irqdevice count\n", progname);
	return EXIT_FAILURE;
}

int main(int ac, char* av[])
{
	int fd,rc,count=0;

	if (ac<3) return Usage(av[0]);

	fd=open(av[1], O_RDWR);
	if (fd<0)
	{
		perror(av[1]);
		return EXIT_FAILURE;
	}

	count=atoi(av[2]);
	if (count==0) return Usage(av[0]);

	for (; count--; )
	{
		rc=irq_simulate(fd);
		if (rc==-1)
		{
			fprintf(stderr, "irq_simulate(%s) error: %s",
				av[1], strerror(errno) );
			return EXIT_FAILURE;
		}
	}

	return EXIT_SUCCESS;
}

