/*
	wait interrupts from IRQ driver by signal.

	(C) 1997 Dmitry A. Fedorov, fedorov@inp.nsk.su
	Copying-policy: LGPL

	$Id: irqsig.c,v 1.16 2001/11/21 05:08:57 fedorov Exp $

	tab size = 4
*/

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <fcntl.h>	/* open */
#include <signal.h>
#include <unistd.h>
#include <sched.h>	/* sched_yield */
#include <string.h>	/* strerror    */
#include <irq.h>


static sig_atomic_t sigcount=0;
static pid_t pid=0;

static void sighandler(int signum)
{
	(void)signum;	/* unused */

#if 0
	printf("process %d sighandler: signal %d, count %u\n",
		pid, signum, sigcount);
#endif

	sigcount++;
}

int main(int ac, char* av[])
{
	int fd,rc;
	struct sigaction sa;
	pid=getpid();

	if (ac<2)
	{
		printf("Usage: %s irqdevice\n", av[0]);
		return EXIT_FAILURE;
	}

	fd=open(av[1], O_RDWR);
	if (fd<0)
	{
		perror(av[1]);
		return EXIT_FAILURE;
	}

	sigemptyset(&sa.sa_mask);
	sa.sa_handler=sighandler;
	sa.sa_flags=SA_RESTART;

	rc=sigaction(SIGUSR2, &sa, NULL);
	if (rc!=0)
	{
		perror("sigaction");
		return EXIT_FAILURE;
	}

	rc=irq_request(fd,SIGUSR2,
#if 1
		IRQ_SHARED
#else
		0
#endif
		);
	if (rc!=0)
	{
		perror("irq_request()");
		return EXIT_FAILURE;
	}

	for (;;)
	{
		pause();
		printf("\rprocess %d pause(): ", pid);
		if (errno==EINTR)
			printf("signal received, sigcount=%u", sigcount);
		else
			printf(strerror(errno));
		printf("\n");
		fflush(stdout);
		sched_yield();
	}

	return EXIT_SUCCESS;
}

