/*
	wait interrupts from IRQ driver by select().

	(C) 1997 Dmitry A. Fedorov, fedorov@inp.nsk.su
	Copying-policy: LGPL

	$Id: irqsel.c,v 1.12 2001/11/21 05:08:16 fedorov Exp $

	tab size = 4
*/

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <fcntl.h>	/* open */
#include <signal.h>
#include <unistd.h>
#include <sched.h>	/* sched_yield      */
#include <sys/time.h>	/* select(), fd_set */
#include <irq.h>


static size_t selcount=0;
static pid_t pid=0;

int main(int ac, char* av[])
{
	int fd, rc;
	fd_set fds;

	pid=getpid();

	if (ac<2)
	{
		printf("Usage: %s irqdevice\n", av[0]);
		return EXIT_FAILURE;
	}

	fd=open(av[1], O_RDWR);
	if (fd<0)
	{
		perror(av[1]);
		return EXIT_FAILURE;
	}

	rc=irq_request(fd, -1,	/* no signals */
#if 1
		IRQ_SHARED
#else
		0
#endif
		);
	if (rc!=0)
	{
		perror("irq_request");
		return EXIT_FAILURE;
	}


	for (;;)
	{
		ssize_t nsel;
		FD_ZERO(&fds);
		FD_SET(fd, &fds);

		nsel=select(fd+1, &fds, NULL, NULL, NULL);
		++selcount;
		if (nsel==-1)
		{
			if (errno==EINTR)
				printf(	"process %d select() interrupted by signal, "
						"selcount=%u", pid, selcount);
			else
			{
				perror("select()");
				return EXIT_FAILURE;
			}
		}
		printf("process %d select(): selcount=%u\n", pid, selcount);

		fflush(stdout);
		sched_yield();
	}

	return EXIT_SUCCESS;
}

