/*
	irq - driver to delivery hardware interrupts to user space.

	Interface definition.

	(C) 1997 Dmitry A. Fedorov, fedorov@inp.nsk.su
	Copying-policy: LGPL

	$Id: irq.h,v 1.21 2001/11/21 04:55:21 fedorov Exp $

	tab size = 4
*/

#ifndef  _IRQ_H
# define _IRQ_H

# ifdef __KERNEL__
#  include <linux/ioctl.h>
# else
#  include <sys/ioctl.h>
# endif

# ifdef __cplusplus
   extern "C" {
# endif


/* + ioctl definitions */

/* free slot from the linux/Documentation/ioctl-number.txt */
# define __IRQ_IOCTL_TYPE_LETTER 'i'

enum
{
	__IRQ_REQUEST_IOCTL_NUMBER=1,
	__IRQ_FREE_IOCTL_NUMBER,

	__IRQ_ENABLE_IOCTL_NUMBER,
	__IRQ_DISABLE_IOCTL_NUMBER,

	__IRQ_SKIPPING_ON_IOCTL_NUMBER,
	__IRQ_SKIPPING_OFF_IOCTL_NUMBER,

	__IRQ_SKIPPING_CONSENT_ON_IOCTL_NUMBER,
	__IRQ_SKIPPING_CONSENT_OFF_IOCTL_NUMBER,

	__IRQ_STAT_IOCTL_NUMBER,

	__IRQ_SIMULATE_IOCTL_NUMBER,
};


#define __IRQ_REQUEST_IOCTL \
	_IOW(__IRQ_IOCTL_TYPE_LETTER, __IRQ_REQUEST_IOCTL_NUMBER, \
		struct __irq_request_arg )

#define __IRQ_FREE_IOCTL \
	_IO (__IRQ_IOCTL_TYPE_LETTER, __IRQ_FREE_IOCTL_NUMBER)

#define __IRQ_ENABLE_IOCTL \
	_IO (__IRQ_IOCTL_TYPE_LETTER, __IRQ_ENABLE_IOCTL_NUMBER)
#define __IRQ_DISABLE_IOCTL \
	_IO (__IRQ_IOCTL_TYPE_LETTER, __IRQ_DISABLE_IOCTL_NUMBER)

#define __IRQ_SKIPPING_ON_IOCTL \
	_IO (__IRQ_IOCTL_TYPE_LETTER, __IRQ_SKIPPING_ON_IOCTL_NUMBER)
#define __IRQ_SKIPPING_OFF_IOCTL \
	_IO (__IRQ_IOCTL_TYPE_LETTER, __IRQ_SKIPPING_OFF_IOCTL_NUMBER)

#define __IRQ_SKIPPING_CONSENT_ON_IOCTL \
	_IO (__IRQ_IOCTL_TYPE_LETTER, __IRQ_SKIPPING_CONSENT_ON_IOCTL_NUMBER)
#define __IRQ_SKIPPING_CONSENT_OFF_IOCTL \
	_IO (__IRQ_IOCTL_TYPE_LETTER, __IRQ_SKIPPING_CONSENT_OFF_IOCTL_NUMBER)

#define __IRQ_STAT_IOCTL \
	_IOR(__IRQ_IOCTL_TYPE_LETTER, __IRQ_STAT_IOCTL_NUMBER, \
		struct irq_stat )

#define __IRQ_SIMULATE_IOCTL \
	_IO (__IRQ_IOCTL_TYPE_LETTER, __IRQ_SIMULATE_IOCTL_NUMBER)

/* - ioctl definitions */


enum irq_flags
{
	IRQ_SHARED=1, IRQ_SKIPPING=4, IRQ_SKIPPING_CONSENT=8
};


struct __irq_request_arg
{
	int sig;
	int flags;
};

struct irq_stat
{
	size_t kstat_interrupts;
	size_t irq_handler_interrupts;
	size_t irq_handler_sent_interrupts;
	size_t irq_count;
	size_t sig_count;
};


/* + ioctl user interface */

# ifndef __KERNEL__

extern __inline__ int irq_request(int fd, int sig, int flags)
{
	struct __irq_request_arg arg = { sig, flags };
	return ioctl(fd, __IRQ_REQUEST_IOCTL, &arg);
}

extern __inline__ int irq_free(int fd)
	{ return ioctl(fd, __IRQ_FREE_IOCTL); }

extern __inline__ int irq_enable(int fd)
	{ return ioctl(fd, __IRQ_ENABLE_IOCTL); }

extern __inline__ int irq_disable(int fd)
	{ return ioctl(fd, __IRQ_DISABLE_IOCTL); }

extern __inline__ int irq_skipping_on(int fd)
	{ return ioctl(fd, __IRQ_SKIPPING_ON_IOCTL); }

extern __inline__ int irq_skipping_off(int fd)
	{ return ioctl(fd, __IRQ_SKIPPING_OFF_IOCTL); }

extern __inline__ int irq_skipping_consent(int fd)
	{ return ioctl(fd, __IRQ_SKIPPING_CONSENT_ON_IOCTL); }

extern __inline__ int irq_skipping_inconsent(int fd)
	{ return ioctl(fd, __IRQ_SKIPPING_CONSENT_OFF_IOCTL); }

extern __inline__ int irq_stat(int fd, struct irq_stat* stat)
	{ return ioctl(fd, __IRQ_STAT_IOCTL, stat); }

extern __inline__ int irq_simulate(int fd)
	{ return ioctl(fd, __IRQ_SIMULATE_IOCTL); }

# endif	//ndef __KERNEL__

/* - ioctl user interface */


# if 0
struct kernel_stat
{
	unsigned int interrupts[NR_IRQS];
};
extern struct kernel_stat kstat;
# endif

# ifdef __cplusplus
}
# endif

#endif	/* _IRQ_H */

