/*
	<linux/df/vprintk.h>
	$Id: vprintk.h,v 1.11 2001/08/09 10:57:53 fedorov Exp $

	Returns the number of bytes written excluding the trailing '\0'.
	Thread can go to sleep.
	This function internally uses an automatic DF_AUTO_BUF_SIZE bytes buffer.
	Overrun cause to stack corruption and kernel memory fault.
	Make sure that will be enough.

	(C) 1999 Dmitry A. Fedorov, fedorov@inp.nsk.su
	Copying policy: GNU GPL
*/

#ifndef  _LINUX_DF_VPRINTK_H
# define _LINUX_DF_VPRINTK_H

# include <stdarg.h>		/* va_list */
# include <linux/types.h>	/* ssize_t */


ssize_t vprintk(const char* fmt, va_list args)
	__attribute__(( format (printf, 1, 0) ));


#endif	/* _LINUX_DF_VPRINTK_H */

