/*
	<linux/df/vfdprintf.h>
	$Id: vfdprintf.h,v 1.7 2001/08/09 10:57:53 fedorov Exp $

	Returns the number of bytes written excluding the trailing '\0'
	or -errno with exception of -EAGAIN and -EWOULDBLOCK.
	Thread can go to sleep.
	This function internally uses an automatic DF_AUTO_BUF_SIZE bytes buffer.
	Overrun cause to stack corruption and kernel memory fault.
	Make sure that will be enough.

	(C) 2000 Dmitry A. Fedorov, fedorov@inp.nsk.su
	Copying policy: GNU GPL
*/

#ifndef  _LINUX_DF_VFDPRINTF_H
# define _LINUX_DF_VFDPRINTF_H

# include <stdarg.h>		/* va_list */
# include <linux/types.h>	/* ssize_t */


ssize_t vfdprintf(uint fd, const char* fmt, va_list args)
	__attribute__(( format (printf, 2, 0) ));


#endif	/* _LINUX_DF_VFDPRINTF_H */

