/*
	<linux/df/strdup_from_user.h>
	$Id: strdup_from_user.h,v 1.0 2001/10/01 06:12:15 fedorov Exp $

	allocate space (kmalloc) and copy string from user.

	(C) 2001 Dmitry A. Fedorov, fedorov@inp.nsk.su
	Copying policy: GNU GPL
*/

#ifndef  _LINUX_DF_STRDUP_FROM_USER_H
# define _LINUX_DF_STRDUP_FROM_USER_H


/*
returns 0 on success or -errno on failure:
	-EINVAL: kdst or usrc ==NULL;
	-EFAULT: invalid address;
	-ENAMETOOLONG: string length >= LONG_MAX
	-ENOMEM: no memory;
allocated string address placed in *kdstptr, use kfree() to free space;
on failure *kdstptr will be NULL.
*/
int df_strdup_from_user(char** kdstptr, const char* const usrc);


#endif	/* _LINUX_DF_STRDUP_FROM_USER_H */

