/*
	<linux/df/printk_stderr.h>
	$Id: printk_stderr.h,v 1.5 2001/08/09 10:57:52 fedorov Exp $

	Do printk()
	and print to current's stderr if ctty presented (no daemon).

	This function calls another function that internally uses
	an automatic DF_AUTO_BUF_SIZE bytes buffer.
	Overrun cause to stack corruption and kernel memory fault.
	Make sure that will be enough.

	(C) 2000 Dmitry A. Fedorov, fedorov@inp.nsk.su
	Copying policy: GNU GPL
*/

#ifndef  _LINUX_DF_PRINTK_STDERR_H
# define _LINUX_DF_PRINTK_STDERR_H

# include <linux/types.h>	/* ssize_t */


ssize_t printk_stderr(const char* fmt, ...)
	__attribute__(( format (printf, 1, 2) ));

ssize_t printk_stderr_endl(void);


#endif	/* _LINUX_DF_PRINTK_STDERR_H */

