/*
	<linux/df/mm_hooks.h>
	$Id: mm_hooks.h,v 1.10 2001/12/10 11:50:25 fedorov Exp $

	should be included first
	('-include FILE' cpp option)

	(C) 2000 Dmitry A. Fedorov, fedorov@inp.nsk.su
	Copying policy: GNU GPL
*/

#ifndef  _LINUX_DF_MM_HOOKS_H
# define _LINUX_DF_MM_HOOKS_H


# ifdef __cplusplus
#  include <linux/cxx/c_headers_begin.h>
# endif

# include <linux/compat/version.h>

# include <linux/compat/malloc.h>
# include <linux/mm.h>
# if LINUX_VERSION_CODE > KERNEL_VERSION(2,1,0)
#  include <linux/vmalloc.h>
# endif

# include <linux/df/mm_counts.h>	/* struct linux_df_mm_counts */


extern int  __original_init_module(void);
extern void __original_cleanup_module(void);


extern void* __df_hooked_kmalloc(size_t size, int priority);
extern void  __df_hooked_kfree  (void* addr);
extern void  __df_hooked_kfree_s(void* addr, size_t size);


extern void* __df_hooked_vmalloc(ulong size);
extern void  __df_hooked_vfree  (void* addr);


# if LINUX_VERSION_CODE > KERNEL_VERSION(2,1,0)
extern ulong __df_hooked___get_free_pages(int gfp_mask, ulong gfp_order);
# else
extern ulong __df_hooked___get_free_pages(int priority, ulong gfp_order,
	int dma);
# endif


extern ulong __df_hooked_get_free_page(int arg);

extern void  __df_hooked_free_pages(ulong addr, ulong order);



extern void
copy_df_mm_counts(struct df_mm_counts* dst);

/* returns 0 or -EFAULT on error */
extern int
copy_df_mm_counts_to_user(struct df_mm_counts* udst);



# ifdef __cplusplus
#  include <linux/cxx/c_headers_end.h>
# endif


# define    init_module __original_init_module
# define cleanup_module __original_cleanup_module


# ifdef  kfree_s
#  define __KFREE_S_DEFINED_AS_MACRO__
#  undef kfree_s
# endif

# define kmalloc(size,priority) __df_hooked_kmalloc(size,priority)
# define kfree(addr)            __df_hooked_kfree(addr)
# define kfree_s(addr,size)     __df_hooked_kfree_s(addr,size)


# define vmalloc(size)          __df_hooked_vmalloc(size)
# define vfree(addr)            __df_hooked_vfree(addr)


# if LINUX_VERSION_CODE > KERNEL_VERSION(2,1,0)
#  define __get_free_pages(mask,order) \
	__df_hooked___get_free_pages(mask, order)
# else
#  define __get_free_pages(priority, order, dma) \
	__df_hooked___get_free_pages(priority, order, dma)
# endif


# define get_free_page(arg)     __df_hooked_get_free_page(arg)

# define free_pages(addr,order) __df_hooked_free_pages(addr, order)


#endif	/* _LINUX_DF_MM_HOOKS_H */

