/*
	<linux/df/kernel_fault.h>
	$Id: kernel_fault.h,v 1.7 2001/08/09 10:57:49 fedorov Exp $

	internal kernel fault
	(by dereferencing 0 pointer)

	(C) 2000 Dmitry A. Fedorov, fedorov@inp.nsk.su
	Copying policy: GNU GPL
*/

#ifndef  _LINUX_DF_KERNEL_FAULT_H
# define _LINUX_DF_KERNEL_FAULT_H

# include <linux/types.h>	/* size_t */
# include <linux/config.h>


# ifdef CONFIG_ARCH_S390
#  define __DF_KERNEL_FAULT asm volatile ( ".word 0\n" )
# else
#  define __DF_KERNEL_FAULT (*(int*)0 = 0)
# endif

# define DF_KERNEL_FAULT(fmt,arg...)	\
	do	\
	{	\
		printk(KERN_CRIT fmt,##arg);	\
		__DF_KERNEL_FAULT;	\
	} while(0)



void df_kernel_fault(const char* function, size_t bufsize)
	__attribute__(( noreturn ));


#endif	/* _LINUX_DF_KERNEL_FAULT_H */

