/*
	<linux/df/get_and_set_fs.h>
	$Id: get_and_set_fs.h,v 1.1 2001/09/11 12:43:47 fedorov Exp $

	save current mm segmnet, set new, return saved segment.

	usage:
		mm_segment_t oldfs = get_and_set_fs(KERNEL_DS);
		[...]
		set_fs(oldfs)

	(C) 2001 Dmitry A. Fedorov, fedorov@inp.nsk.su
	Copying policy: GNU GPL
*/

#ifndef  _LINUX_DF_GET_AND_SET_FS_H
# define _LINUX_DF_GET_AND_SET_FS_H

# include <linux/compat/processor.h>	/* mm_segment_t              */
# include <linux/compat/uaccess.h>	/* set_fs, get_fs, KERNEL_DS */


// returns old mm segment.
extern inline
mm_segment_t df_get_and_set_fs(mm_segment_t newfs)
{
    mm_segment_t oldfs = get_fs(); set_fs(newfs); return oldfs;
}


#endif	/* _LINUX_DF_GET_AND_SET_FS_H */

