/*
	<linux/df/fs.h>
	$Id: fs.h,v 1.7 2001/08/09 10:57:49 fedorov Exp $

	struct inode* df_file_inode(struct file* file);
		look up inode from file with check against f_dentry null pointer.

	struct super_block* get_super_by_fstypename(const char* fstypename);
		2.0.x only

	(C) 2000 Dmitry A. Fedorov, fedorov@inp.nsk.su
	Copying policy: GNU GPL
*/

#ifndef  _LINUX_DF_FS_H
# define _LINUX_DF_FS_H

# include <linux/compat/version.h>
# include <linux/fs.h>
# include <linux/df/assert.h>


extern inline struct inode* df_file_inode(struct file* file)
{
	assert_retval(file != NULL, NULL);

# if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,43)
	return file->f_inode;
# else
	return file->f_dentry ? file->f_dentry->d_inode : NULL;
# endif
}


# if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,0)
struct super_block* df_get_super_by_fstypename(const char* fstypename);
struct inode      * df_get_inode_by_fstypename(const char* fstypename,
	ulong ino);
# endif


#endif	/* _LINUX_DF_FS_H */

