/*
	<linux/df/file.h>
	$Id: file.h,v 1.19 2001/08/09 10:57:49 fedorov Exp $

	struct file utilities

	(C) 1999 Dmitry A. Fedorov, fedorov@inp.nsk.su
	Copying policy: GNU GPL
*/

#ifndef  _LINUX_DF_FILE_H
# define _LINUX_DF_FILE_H

# include <linux/compat/fs.h>		/* struct file */
# include <linux/sched.h>			/* current */


/* with no check */
extern inline struct file* df_lookup_file_by_fd(unsigned int fd)
{
	return current->files->fd[fd];
}


extern inline int df_check_file_owner_pid(const struct file* file)
{
	return (FILE_OWNER_PID(file) != current->pid) ? -EACCES : 0;
}


/* fcntl(fd, F_SETOWN, current->pid) */
void df_set_file_owner(struct file* file);


/*
Creates new empty file struct and binded file descriptor entry.
Returns file descriptor and sets *pfilp to file pointer.
On error returns -errno and sets *pfilp to NULL.
*/
int df_create_fd_and_file(struct file** pfilp);


/* attach new file to old file inode/dentry */
int df_attach_file_to_file(struct file* newfile, struct file* oldfile);


#endif	/* _LINUX_DF_FILE_H */

