/*
	<linux/df/fdprintf.h>
	$Id: fdprintf.h,v 1.5 2001/08/09 10:57:48 fedorov Exp $

	Returns the number of bytes written excluding the trailing '\0'
	or -errno with exception of -EAGAIN and -EWOULDBLOCK.
	Thread can go to sleep.
	This function calls another function that internally uses
	an automatic DF_AUTO_BUF_SIZE bytes buffer.
	Overrun cause to stack corruption and kernel memory fault.
	Make sure that will be enough.

	(C) 2000 Dmitry A. Fedorov, fedorov@inp.nsk.su
	Copying policy: GNU GPL
*/

#ifndef  _LINUX_DF_FDPRINTF_H
# define _LINUX_DF_FDPRINTF_H

# include <linux/types.h>	/* ssize_t */


ssize_t fdprintf(uint fd, const char* fmt, ...)
	__attribute__(( format (printf, 2, 3) ));


#endif	/* _LINUX_DF_FDPRINTF_H */

