/*
	<linux/df/dma.h>
	$Id: dma.h,v 1.6 2001/08/09 10:57:48 fedorov Exp $

	(C) 1999 Dmitry A. Fedorov, fedorov@inp.nsk.su
	Copying policy: GNU GPL
*/

#ifndef  _LINUX_DF_DMA_H
# define _LINUX_DF_DMA_H

# include <linux/compat/dma.h>
# include <linux/df/testbit.h>
# include <linux/df/assert.h>


# if #cpu (i386)

extern inline int is_dma1_ready(int drq)
{
	assert_retval((uint)drq<MAX_DMA_CHANNELS, 0);

	return testbit(drq, inb(DMA1_STAT_REG) & 0x0f);
}

extern inline int is_dma2_ready(int drq)
{
	assert_retval((uint)drq<MAX_DMA_CHANNELS, 0);

	return testbit(drq-4, inb(DMA2_STAT_REG) & 0x0f);
}

extern inline int is_dma_ready(int drq)
{
	return drq<4 ? is_dma1_ready(drq) : is_dma2_ready(drq);
}

# endif


#endif	/* _LINUX_DF_DMA_H */

