/*
	<linux/df/devprobe.h>
	$Id: devprobe.h,v 1.10 2001/07/08 04:44:52 fedorov Exp $

	device probing constants

	(C) 1999 Dmitry A. Fedorov, fedorov@inp.nsk.su
	Copying policy: GNU GPL
*/

#ifndef  _LINUX_DF_DEVICE_PROBE_H
# define _LINUX_DF_DEVICE_PROBE_H

# include <dfcommon/types.h>

/* any type I/O address */
# define   IS_IO_PROBE_AUTO(addr) (!(addr))
# define   IS_IO_PROBE_NONE(addr) ( (addr) == (__typeof__(addr)) ~0ul )

/* any type I/O address */
# define      IO_PROBE_AUTO  (                  0ul)
# define      IO_PROBE_NONE  (                 ~0ul)

# define PORT_IO_PROBE_AUTO  ( (port_io_addr_t) 0ul)
# define PORT_IO_PROBE_NONE  ( (port_io_addr_t)~0ul)

# define  MEM_IO_PROBE_AUTO  (  (mem_io_addr_t) 0ul)
# define  MEM_IO_PROBE_NONE  (  (mem_io_addr_t)~0ul)

# define     IRQ_PROBE_AUTO  (          (irq_t) 0ul)
# define     IRQ_PROBE_NONE  (          (irq_t)~0ul)

# define     DRQ_PROBE_AUTO  (          (drq_t) 0ul)
# define     DRQ_PROBE_NONE  (          (drq_t)~0ul)

# if #cpu (i386)
#  define LOW_PORT_IO_ADDR_MAX ((port_io_addr_t)0x3ff)
#  define LOW_MEM_IO_ADDR      ( (mem_io_addr_t)0xA0000)
# else	/* this #cpu unsupported yet */
#  undef  LOW_PORT_IO_ADDR_MAX
#  undef  LOW_MEM_IO_ADDR
# endif

#endif	/* _LINUX_DF_DEVICE_PROBE_H */

