/*
	<linux/df/dev-entries.h>
	$Id: dev-entries.h,v 1.4 2003/06/16 12:36:43 fedorov Exp $

	(C) 2001 Dmitry A. Fedorov, fedorov@inp.nsk.su
	Copying policy: GNU GPL
*/

#ifndef  _LINUX_DF_DEV_ENTRIES_H
# define _LINUX_DF_DEV_ENTRIES_H

# include <linux/types.h>	/* size_t, mode_t, uid_t, gid_t */
# include <linux/compat/compiler.h>
# include <linux/df/syscalls.h>


/* returns 0 or -errno on error (mknod,chown errors) */
int __df_create_dev_entry( const char __kernel* name,
			   size_t major, size_t minor,
			   mode_t mode, uid_t uid, gid_t gid );


/* returns 0 or -errno on error (mknod,chown errors). */
extern inline
int df_create_dev_entry( const char __kernel* name,
			 size_t major, size_t minor,
			 mode_t mode, uid_t uid, gid_t gid )
{
    return __df_create_dev_entry( name, major, minor, mode, uid, gid );
}

/* returns 0 or -errno on error (unlink errors). */
extern inline
int df_delete_dev_entry( const char __kernel* name )
{
    return df_unlink( name );
}



/* returns 0 or -errno on error, -ENOMEM or mknod/chown errors.
   on error part of device entries can be created.		*/
int __df_create_dev_entries( size_t major, const char __kernel* basename,
			     size_t min_minor, size_t max_minor,
			     mode_t mode, uid_t uid, gid_t gid,
			     int delete );


/* returns 0 or -errno on error, -ENOMEM or mknod/chown errors.
   on error part of device entries can be created.		*/
extern inline
int df_create_dev_entries( size_t major, const char __kernel* basename,
			   size_t min_minor, size_t max_minor,
			   mode_t mode, uid_t uid, gid_t gid )
{
    return __df_create_dev_entries( major, basename,
				    min_minor, max_minor,
				    mode, uid, gid, 0 );
}


/* returns 0 or -errno on error, -ENOMEM or unlink errors.
   -ENOENT is not an error and would not returned.
   on error part of device entries can be left.			*/
extern inline
int df_delete_dev_entries(const char __kernel* basename,
			  size_t min_minor, size_t max_minor)
{
    return __df_create_dev_entries( 0, basename, min_minor, max_minor,
				    0, 0, 0, 1 );
}


#endif	/* _LINUX_DF_DEV_ENTRIES_H */

