/*
	<linux/df/bh.h>
	$Id: bh.h,v 1.16 2001/08/09 10:57:48 fedorov Exp $

	(C) 1999 Dmitry A. Fedorov, fedorov@inp.nsk.su
	Copying policy: GNU GPL
*/

#ifndef  _LINUX_DF_BH_H
# define _LINUX_DF_BH_H

# include <linux/compat/tqueue.h>	/* tq_struct, queue_task*() */
# include <linux/string.h>			/* memset() */


typedef struct tq_struct bh_t;

typedef	void (*bh_handler_t)(void*);


extern inline void bh_init0(bh_t* bh)
{
	memset(bh, 0, sizeof(bh_t));
}

extern inline void bh_init(bh_t* bh, bh_handler_t bh_handler, void* bh_arg)
{
	bh->next=NULL;
	bh->sync=0;
	bh->data=bh_arg;
	bh->routine=bh_handler;
}

extern inline void bh_queue(bh_t* bh, task_queue* bh_list)
	{ queue_task(bh, bh_list); }

extern inline void bh_queue_irq(bh_t* bh, task_queue* bh_list)
	{ queue_task_irq(bh, bh_list); }

extern inline void bh_queue_irq_off(bh_t* bh, task_queue* bh_list)
	{ queue_task_irq_off(bh, bh_list); }


#endif	/* _LINUX_DF_BH_H */

