/*
	<linux/df/assert.h>
	$Id: assert.h,v 1.12 2001/08/09 09:31:26 fedorov Exp $
*/

#ifndef  _LINUX_DF_ASSERT_H
# define _LINUX_DF_ASSERT_H


# ifdef NDEBUG

#  define assert(expr)            ((void) 0)
#  define assert_retvoid(expr)    ((void) 0)
#  define assert_retval(expr,val) ((void) 0)
#  define assert_goto(expr,label) ((void) 0)
#  define assert_break(expr)      ((void) 0)

# else	/* ndef NDEBUG */

#  include <linux/kernel.h>		/* printk */

#  define __assertion_failed(expr) \
	( printk(KERN_ERR "%s:%u: %s: Assertion `%s' failed.\n", \
		__FILE__, __LINE__, __PRETTY_FUNCTION__, #expr) )

#  define __assert(expr) \
	( (expr) ? 1 : (__assertion_failed(expr), 0) )

#  define assert(expr) ((void) __assert(expr))

#  define assert_retvoid(expr) \
	do { if (!__assert(expr)) return; } while(0)

#  define assert_retval(expr,val) \
	do { if (!__assert(expr)) return (val); } while(0)

#  define assert_goto(expr,label) \
	do { if (!__assert(expr)) goto label; } while(0)

#  define assert_break(expr) \
	if (!__assert(expr)) break

# endif	/* def NDEBUG */


#endif	/* _LINUX_DF_ASSERT_H */

