/*
	<linux/compat/version.h>

	Kernel version macros

	compiled from kernel sources by Dmitry Fedorov, fedorov@inp.nsk.su

	$Id: version.h,v 1.10 2001/12/15 14:08:33 fedorov Exp $
*/

#ifndef  _LINUX_COMPAT_VERSION_H
# define _LINUX_COMPAT_VERSION_H

# include <linux/version.h>	/* LINUX_VERSION_CODE, KERNEL_VERSION() */

# ifndef  KERNEL_VERSION
#  define KERNEL_VERSION(v, p, s)	( ((v)<<16) + ((p)<<8) + (s) )
# endif


/* + unstable */

# ifndef  LVC_VERSION
#  define LVC_VERSION(lvc)     ( ((lvc)>>16) & 0xFF )
# endif

# ifndef  LVC_PATCHLEVEL
#  define LVC_PATCHLEVEL(lvc)  ( ((lvc)>>8) & 0xFF )
# endif

# ifndef  LVC_SUBLEVEL
#  define LVC_SUBLEVEL(lvc)    ( (lvc) & 0xFF )
# endif

# ifndef  IS_LINUX_DEVELOPMENT_VERSION
#  define IS_LINUX_DEVELOPMENT_VERSION \
		((LVC_PATCHLEVEL(LINUX_VERSION_CODE) % 2) != 0)
# endif

# if IS_LINUX_DEVELOPMENT_VERSION
#  error Kernel development versions are not supported
# endif

/* - unstable */

#endif	/* _LINUX_COMPAT_KERNEL_VERSION_H */

