/*
	<linux/compat/timer.h>

	<linux/timer.h> is the same for the version ranges:
	2.0.0  - 2.0.39
	2.2.0  - 2.2.19
	2.4.0  - 2.4.4
	2.4.5  - 2.4.12

	compiled from kernel sources by Dmitry Fedorov, fedorov@inp.nsk.su

	$Id: timer.h,v 1.1 2001/10/21 11:10:51 fedorov Exp $
*/

#ifndef  _LINUX_COMPAT_TIMER_H
# define _LINUX_COMPAT_TIMER_H

# include <linux/compat/version.h>
# include <linux/compat/null.h>
# include <linux/timer.h>


# if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,0)
static inline int mod_timer(struct timer_list *timer, unsigned long expires)
{
    int pending = del_timer(timer);
    timer->expires = expires;
    add_timer(timer);
    return pending;
}
# endif


# if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0)
#  define del_timer_sync(timer) del_timer(timer)
# endif


# if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,0)
#  define time_after(a,b)	((long)(b) - (long)(a) < 0)
#  define time_before(a,b)	time_after(b,a)

#  define time_after_eq(a,b)	((long)(a) - (long)(b) >= 0)
#  define time_before_eq(a,b)	time_after_eq(b,a)

extern inline int timer_pending(const struct timer_list* timer)
{
	return timer->prev != NULL;
}
# endif


#endif	/* _LINUX_COMPAT_TIMER_H */

