/*
	<linux/compat/system.h>

	some compatibility macros for asm/system.h

	compiled from kernel sources by Dmitry Fedorov, fedorov@inp.nsk.su

	$Id: system.h,v 1.12 2001/10/21 12:10:16 fedorov Exp $
*/

#ifndef  _LINUX_COMPAT_SYSTEM_H
# define _LINUX_COMPAT_SYSTEM_H

# include <linux/compat/version.h>
# include <asm/system.h>


# if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,0)
#  define rmb() mb()
#  define wmb() mb()
#
#  define __cli() cli()
#  define __sti() sti()
#
#  define    __save_flags(x)    save_flags(x)
#  define __restore_flags(x) restore_flags(x)
# endif


/* __xchg() was buggy! */
# if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0)
#  define xchg_compat(ptr,v) \
	({ register __typeof__(*(ptr)) volatile __t = xchg((ptr),(v)); __t; })
# else
#  define xchg_compat(ptr,v) xchg((ptr),(v))
# endif


# if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0)
#  define  set_mb(var, value) do { (var) = (value);  mb(); } while (0)
#  define set_wmb(var, value) do { (var) = (value); wmb(); } while (0)
# endif


#endif	/* _LINUX_COMPAT_SYSTEM_H */

