/*
	<linux/compat/sys_call_ret.h>

	system calls return types

	(C) 2002 Dmitry A. Fedorov, fedorov@inp.nsk.su

	$Id: sys_call_ret.h,v 1.1 2003/06/06 12:49:50 fedorov Exp $
*/

#ifndef  _LINUX_COMPAT_SYS_CALL_H
# define _LINUX_COMPAT_SYS_CALL_H

# include <linux/compat/version.h>


# if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0)
    typedef int  sys_sched_yield_ret_t;
    typedef int  sys_chown_ret_t;
    typedef int  sys_mknod_ret_t;
    typedef int  sys_open_ret_t;
    typedef int  sys_close_ret_t;
    typedef int  sys_unlink_ret_t;
# else
    typedef long sys_sched_yield_ret_t;
    typedef long sys_chown_ret_t;
    typedef long sys_mknod_ret_t;
    typedef long sys_open_ret_t;
    typedef long sys_close_ret_t;
    typedef long sys_unlink_ret_t;
# endif


#endif	/* _LINUX_COMPAT_SYS_CALL_H */

